package cn.smarthse.radiationTraining.modules.training.entity.course;


import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableId;
import lombok.Data;
import lombok.experimental.Accessors;

import javax.persistence.Table;
import java.io.Serializable;
import java.util.Date;

@Data
@Table(name = "course_item_indusrty")
@Accessors(chain = true)
public class CourseItemIndustry implements Serializable {
    /**
     * 编号
     */
    @TableId(value = "id", type = IdType.ASSIGN_ID)
    private Long id;
    /**
     * 等级
     */
    private Integer level;
    /**
     * 父code
     */
    private String pcode;
    /**
     * 人员类型code
     */
    private String code;
    /**
     * 人员类型名称
     */
    private String name;
    /**
     * 是否是叶子节点(0:不是; 1:是)
     */
    private Integer isLeaf;
    /**
     * 后代节点数量
     */
    private Long progenyNum;
    /**
     * 课程表id
     */
    private Long courseItemId;
    /**
     * 创建人
     */
    private Long createBy;
    /**
     * 更新人
     */
    private Long updateBy;
    /**
     * 创建时间
     */
    private Date createDate;
    /**
     * 更新时间
     */
    private Date updateDate;
    /**
     * 是否有效（0-无效，1-有效）
     */
    private Long isValid;

    public CourseItemIndustry() {
    }

    public CourseItemIndustry(String code, String name) {
        this.code = code;
        this.name = name;
    }
}
