package cn.smarthse.radiationTraining.modules.training.entity.course;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableId;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.experimental.Accessors;

import javax.persistence.Table;
import java.io.Serializable;
import java.util.Date;


@Data
@Table(name = "course_group")
@Accessors(chain = true)
public class CourseGroup implements Serializable {
    /**
     * 编号
     */
    @ApiModelProperty("编号")
    @TableId(value = "id", type = IdType.ASSIGN_ID)
    private Long id;

    @ApiModelProperty("课程组名")
    private String name;

    @ApiModelProperty("培训目标类型（200000用人单位 300002医用放射工作人员 300003非医用放射工作人员")
    private String trainingTargetType;

    @ApiModelProperty("编辑人")
    private Long editor;

    @ApiModelProperty("课程数量")
    private Long courseNumber;


    @ApiModelProperty("状态（1：启用、2：禁用）")
    private Integer status;

    @ApiModelProperty("类型（0普通 1默认 2老极简 3新极简）")
    private Integer type;


    private Long createBy;


    private Long updateBy;

    private Date createDate;

    private Date updateDate;


    private Integer isValid;

}
