package cn.smarthse.radiationTraining.modules.training.entity.certificate;

import com.baomidou.mybatisplus.annotation.*;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.util.Date;


/**
 * <p>
 * 证书模板管理 表
 * </p>
 *
 * @author wuxq
 * @since 2022-3-21
 */
@Data
@TableName("certificate")
public class Certificate implements Serializable {

    private static final long serialVersionUID = 1L;

    @TableId(value = "id", type = IdType.ASSIGN_ID)
    private Long id;

    @ApiModelProperty("证书名称")
    private String name;

    @ApiModelProperty("培训内容")
    private String trainingContent;

    @ApiModelProperty("培训单位名称")
    private String trainingUnitName;

    @ApiModelProperty("培训单位简称")
    private String trainingUnitShortName;

    @ApiModelProperty("说明描述")
    @TableField(updateStrategy = FieldStrategy.IGNORED)
    private Date issueTime;

    @ApiModelProperty("状态（1：无效；2：有效）")
    private Integer status;

    @ApiModelProperty("培训单位公章url")
    @TableField(updateStrategy = FieldStrategy.IGNORED)
    private String officialSealUrl;

    /**
     * 创建者ID
     */
    private Long createBy;
    /**
     * 创建时间
     */
    private Date createDate;
    /**
     * 更新者ID
     */
    private Long updateBy;
    /**
     * 更新时间
     */
    private Date updateDate;
    /**
     * 是否有效（0：无效，1：有效）
     */
    private Boolean isValid;


}
