/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.radiationTraining.modules.training.enums;

import cn.hutool.core.collection.CollectionUtil;
import cn.smarthse.radiationTraining.core.framework.utils.StringUtils;
import java.util.List;
import javax.smarthse.radiationTraining.exception.ServiceException;

public enum TrainingPersonTypeEnum {
    MAIN_IN_CHARGE("200001", "\u4e3b\u8981\u8d1f\u8d23\u4eba", 1),
    HEALTH_ADMIN("200002", "\u804c\u4e1a\u536b\u751f\u7ba1\u7406\u4eba\u5458", 2),
    OTHER("200000", "\u5176\u4ed6", 0),
    OCCUPATION_TECH_CHECK("200004", "\u804c\u4e1a\u536b\u751f\u68c0\u6d4b\u6280\u672f\u4eba\u5458", 4),
    RADIO_TECH_CHECK("200005", "\u653e\u5c04\u536b\u751f\u68c0\u6d4b\u6280\u672f\u4eba\u5458", 5),
    OCCUPATION_TECH_APPRAISE("200006", "\u804c\u4e1a\u536b\u751f\u8bc4\u4ef7\u6280\u672f\u4eba\u5458", 6),
    RADIO_TECH_APPRAISE("200007", "\u653e\u5c04\u536b\u751f\u8bc4\u4ef7\u6280\u672f\u4eba\u5458", 7),
    PHYSICAL_EXAMINATION_DOC("200008", "\u804c\u4e1a\u5065\u5eb7\u4f53\u68c0\u4e3b\u68c0\u533b\u5e08", 8);

    private String value;
    private String name;
    private int tcode;

    private TrainingPersonTypeEnum(String value, String name, Integer tcode) {
        this.value = value;
        this.name = name;
        this.tcode = tcode;
    }

    public static Integer getTcode(String value) {
        if (value == null) {
            return OTHER.getTcode();
        }
        for (TrainingPersonTypeEnum e : TrainingPersonTypeEnum.values()) {
            if (!e.getValue().equals(value)) continue;
            return e.getTcode();
        }
        return OTHER.getTcode();
    }

    public static String getValue2(String value) {
        return value.substring(value.length() - 2);
    }

    public static String getName(String v) {
        if (v == null) {
            return null;
        }
        for (TrainingPersonTypeEnum e : TrainingPersonTypeEnum.values()) {
            if (!e.getValue().equals(v)) continue;
            return e.getName();
        }
        return null;
    }

    public String getValue() {
        return this.value;
    }

    public void setValue(String value) {
        this.value = value;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public int getTcode() {
        return this.tcode;
    }

    public void setTcode(int tcode) {
        this.tcode = tcode;
    }

    public static Boolean isOrgCode(String value) {
        if (StringUtils.isEmpty((CharSequence)value)) {
            throw new ServiceException("\u4eba\u5458\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (OCCUPATION_TECH_CHECK.getValue().equals(value) || RADIO_TECH_CHECK.getValue().equals(value) || OCCUPATION_TECH_APPRAISE.getValue().equals(value) || RADIO_TECH_APPRAISE.getValue().equals(value) || PHYSICAL_EXAMINATION_DOC.getValue().equals(value)) {
            return true;
        }
        if ("200001".equals(value) || "200002".equals(value)) {
            return false;
        }
        throw new ServiceException("\u4eba\u5458\u7c7b\u578b\u9519\u8bef");
    }

    public static Boolean isOrgCodes(List<String> values) {
        if (CollectionUtil.isEmpty(values)) {
            throw new ServiceException("\u4eba\u5458\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a");
        }
        for (String v : values) {
            if (TrainingPersonTypeEnum.isOrgCode(v).booleanValue()) continue;
            return false;
        }
        return true;
    }

    public static String getNameByValue(String value) {
        if (value == null) {
            throw new ServiceException("\u4eba\u5458\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a");
        }
        for (TrainingPersonTypeEnum a : TrainingPersonTypeEnum.values()) {
            if (!a.getValue().equals(value)) continue;
            return a.getName();
        }
        return "";
    }
}

