/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.radiationTraining.modules.training.enums;

public enum CertBgEnum {
    GOLD_C(1000L, "\u91d1\u8272\u80cc\u666f-\u6a2a\u7248", "gold", "#E7C485", "c"),
    GOLD_V(1001L, "\u91d1\u8272\u80cc\u666f-\u7ad6\u7248", "gold", "#E7C485", "v"),
    GRAY_C(1010L, "\u7070\u84dd\u80cc\u666f-\u6a2a\u7248", "gray", "#768298", "c"),
    GRAY_V(1011L, "\u7070\u84dd\u80cc\u666f-\u7ad6\u7248", "gray", "#768298", "v"),
    GREEN_C(1020L, "\u7eff\u8272\u80cc\u666f-\u6a2a\u7248", "green", "#78AF64", "c"),
    GREEN_V(1021L, "\u7eff\u8272\u80cc\u666f-\u7ad6\u7248", "green", "#78AF64", "v"),
    RED_C(1030L, "\u7ea2\u8272\u80cc\u666f-\u6a2a\u7248", "red", "#621014", "c"),
    RED_V(1031L, "\u7ea2\u8272\u80cc\u666f-\u7ad6\u7248", "red", "#621014", "v"),
    JG_C(2000L, "\u6280\u672f\u670d\u52a1\u673a\u6784-\u91d1\u8272\u80cc\u666f-\u6a2a\u7248", "gold", "#E7C485", "jg_c"),
    JG_V(2001L, "\u6280\u672f\u670d\u52a1\u673a\u6784-\u91d1\u8272\u80cc\u666f-\u7ad6\u7248", "gold", "#E7C485", "jg_v");

    private final Long value;
    private final String name;
    private final String color;
    private final String colorValue;
    private final String layout;

    private CertBgEnum(Long value, String name, String color, String colorValue, String layout) {
        this.value = value;
        this.name = name;
        this.color = color;
        this.colorValue = colorValue;
        this.layout = layout;
    }

    public static String getColor(Long value) {
        if (value == null) {
            return null;
        }
        for (CertBgEnum e : CertBgEnum.values()) {
            if (!e.getValue().equals(value)) continue;
            return e.getColor();
        }
        return null;
    }

    public static String getColorValue(Long value) {
        if (value == null) {
            return RED_C.getColorValue();
        }
        for (CertBgEnum e : CertBgEnum.values()) {
            if (!e.getValue().equals(value)) continue;
            return e.getColorValue();
        }
        return RED_C.getColorValue();
    }

    public static String getLayout(Long value) {
        if (value == null) {
            return null;
        }
        for (CertBgEnum e : CertBgEnum.values()) {
            if (!e.getValue().equals(value)) continue;
            return e.getLayout();
        }
        return null;
    }

    public static boolean isRotate(Long value) {
        return "c".equalsIgnoreCase(CertBgEnum.getLayout(value));
    }

    public static String getBgImg(Long value) {
        String color = CertBgEnum.getColor(value);
        String layout = CertBgEnum.getLayout(value);
        return color + "_" + layout + ".png";
    }

    public static String getCertFile(Long value) {
        String layout = CertBgEnum.getLayout(value);
        return "cert_" + layout + ".html";
    }

    public Long getValue() {
        return this.value;
    }

    public String getName() {
        return this.name;
    }

    public String getColor() {
        return this.color;
    }

    public String getColorValue() {
        return this.colorValue;
    }

    public String getLayout() {
        return this.layout;
    }
}

