package cn.smarthse.radiationTraining.modules.training.vo.training;

import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.util.Date;

/**
 * Description:个人用户-我的培训列表 vo
 *
 * @Author:chuhy
 * @create:2022/3/24
 */
@Data
public class UserMyTrainListVo implements Serializable {
    private static final long serialVersionUID = -4915607368747904715L;

    @ApiModelProperty("id")
    private Long id;

    @ApiModelProperty("培训id")
    private Long tid;

    @ApiModelProperty("用户id")
    private Long uid;

    @ApiModelProperty("企业id")
    private Long cid;
    @ApiModelProperty("单位报名id")
    private Long enrollId;

    @ApiModelProperty("报名详情id")
    private Long enrollDetailId;

    @ApiModelProperty("培训名称")
    private String trainName;

    @ApiModelProperty("培训对象(0-用人单位；11-技术服务机构；12-职业健康体检机构；13-技术服务、职业健康体检机构)")
    private Integer trainTarget;

    @ApiModelProperty("培训模式(0-专业; 1-精准;2-服务机构)")
    private Integer trainMode;

    @ApiModelProperty("用人单位名称")
    private String unitName;

    @ApiModelProperty("报名时间")
    private Date enrollTime;

    @ApiModelProperty("报名截止时间")
    private Date signEndTime;

    @ApiModelProperty(hidden = true, value = "适用工作类别Code集合(Code和名称在这里不是一一对应的)")
    private String trainWorkTypeCodeList;

    @ApiModelProperty("适用工作类别名称集合")
    private String trainWorkTypeNameList;

    @ApiModelProperty("人员类别名称集合")
    private String personTypeNameList;

    @ApiModelProperty("行业名称集合")
    private String trainIndustryNameList;

    @ApiModelProperty("已学习课程数")
    private Integer studiedProgress;

    @ApiModelProperty("考试进度(1/10)")
    private String testedProgress;

    @ApiModelProperty("考试进度(为了不影响APP修改，专门给前端返回的值)")
    private String testedProgressTwo;

    @ApiModelProperty("考试进度(1/10)")
    private String testedProgressTotal;

    @ApiModelProperty("所有课程数")
    private Integer courseNum;

    @ApiModelProperty("报名来源(1-个人；2-单位)")
    private Byte enrollSource;

    @ApiModelProperty("状态 (0-退回；1-待培训；2-培训中；3-已取证；4-培训结束 5-待报名)")
    private Byte trainStatus;

    @ApiModelProperty("培训类型")
    private String trainType;

    @ApiModelProperty("是否考试：0-否；1-是；")
    private Integer mustTest;

    @ApiModelProperty("考试方式(0-分别考试；1-统一考试)")
    private Integer testMode;

    @ApiModelProperty("培训开始时间")
    private Date trainStarTime;

    @ApiModelProperty("培训结束时间")
    private Date trainEndTime;

    @ApiModelProperty("考试截止时间")
    private Date testEndTime;

    @ApiModelProperty("封面url")
    private String coverUrl;

    @ApiModelProperty("目标证书")
    private String targetCertificate;

    @ApiModelProperty("目标证书名称")
    private String certificateName;

    @ApiModelProperty("证书id")
    private String tuCertificateId;

    @ApiModelProperty("是否已报名(0-否；1-是)")
    private Byte isEnroll;

    @ApiModelProperty("人脸识别(0-不需要;1-需要)")
    private Byte isFaceRecognition;

    @ApiModelProperty("是否在线考试(0-否；1-是)")
    private Integer isTestOnline;

    @ApiModelProperty("包考试含未通过课程")
    private Boolean isIncludeFlunked = false;

    @ApiModelProperty("统一考试-考试状态(0-待考试；1-未通过；2-已通过)")
    private Integer testStatus;

    @ApiModelProperty("统一考试-剩余考试次数")
    private Integer retestLimit;

    @ApiModelProperty("统一考试 - 答题时长(分钟)")
    private Integer testDuration;

    @ApiModelProperty("证书url")
    private String pdfUrl;

    @ApiModelProperty("证书人员类型")
    private String certType;

    @ApiModelProperty("证书人员类型")
    private String personTypeCode;

    @ApiModelProperty("已完成学时")
    private Double studiedClassHour;

    @ApiModelProperty("学时及格线")
    private Double passClassHour;

    @ApiModelProperty("总学时")
    private Double classHourTotal;

    @ApiModelProperty("培训版本")
    private String version;

}
