package cn.smarthse.radiationTraining.modules.training.vo.training;

import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.util.Date;

/**
 * Description:培训-单位用户列表 vo
 *
 * @Author:chuhy
 * @create:2022/3/14
 */
@Data
public class TrainingUnitEnrollVo implements Serializable {
    private static final long serialVersionUID = -4559222080761749564L;

    @ApiModelProperty(value = "单位用户报名ID(tu_enroll.id)")
    private Long id;

    @ApiModelProperty(value = "单位ID")
    private Long cid;

    @ApiModelProperty(value = "单位账号ID")
    private Long userId;

    @ApiModelProperty("单位名称")
    private String companyName;

    @ApiModelProperty("社会信用代码")
    private String creditCode;

    @ApiModelProperty("培训开始时间")
    private Date trainStarTime;

    @ApiModelProperty("报名时间")
    private Date enrollTime;

    @ApiModelProperty("报名人数")
    private Integer enrollNum;

    @ApiModelProperty("已取证人数")
    private Integer hasCertificateNum;

    @ApiModelProperty("培训状态(0-退回；1-待培训；2-培训中；4-培训结束,5-草稿)")
    private Byte trainStatus;


    @ApiModelProperty("是否可以退回（0-否;1-是）")
    private Integer isReturn;
}
