package cn.smarthse.radiationTraining.modules.training.vo.training;

import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.util.Date;

/**
 * Description:培训-个人用户列表 vo
 *
 * @Author:chuhy
 * @create:2022/3/14
 */
@Data
public class TrainingPersonEnrollVo implements Serializable {

    private static final long serialVersionUID = -1845627381398962895L;

    @ApiModelProperty(value = "个人用户报名ID(tu_enroll_detail.id)")
    private Long id;

    @ApiModelProperty("用户ID")
    private Long uid;

    @ApiModelProperty("培训ID")
    private Long tid;

    @ApiModelProperty("报名详情id")
    private Long tuEnrollDetailId;
    @ApiModelProperty("证书id")
    private Long tuCertificateId;

    @ApiModelProperty("培训名称")
    private String trainName;

    @ApiModelProperty("单位名称")
    private String companyName;

    @ApiModelProperty("用户姓名")
    private String uname;

    @ApiModelProperty("用户账号")
    private String username;

    @ApiModelProperty("区域名称")
    private String areaName;

    @ApiModelProperty("身份证号")
    private String idCard;

    @ApiModelProperty("报名来源(1-个人；2-单位)")
    private Byte enrollSource;

    @ApiModelProperty("培训开始时间")
    private Date trainStarTime;

    @ApiModelProperty("报名时间")
    private Date enrollTime;

    @ApiModelProperty("已学完课程数")
    private Integer studiedProgress;

    @ApiModelProperty("全部课程数")
    private Integer allCourseNum;

    @ApiModelProperty("已通过必过")
    private Integer testedProgress;

    @ApiModelProperty("总必过数")
    private Integer allPassNum;

    @ApiModelProperty("培训状态(0-退回；1-待培训；2-培训中；3-已取证；4-培训结束)")
    private Byte trainStatus;

    @ApiModelProperty("适用工作类别集合")
    private String trainWorkTypeNameList;

    @ApiModelProperty("人员类型Code(用英文逗号隔开)")
    private String personTypeCode;

    @ApiModelProperty("人员类型集合")
    private String personTypeNameList;

    @ApiModelProperty("是否在线考试(0-否；1-是)")
    private Integer isTestOnline;


    @ApiModelProperty("证书url")
    private String pdfUrl;

    @ApiModelProperty("证书人员类型")
    private String certType;

    @ApiModelProperty("删除时间")
    private Date delTime;

    @ApiModelProperty("删除人")
    private String delName;

    @ApiModelProperty(value = "删除人id",hidden = true)
    private Long updateBy;


}
