package cn.smarthse.radiationTraining.modules.training.vo.training;

import cn.smarthse.radiationTraining.modules.training.entity.training.Training;
import cn.smarthse.radiationTraining.modules.training.entity.training.TrainingIndustry;
import cn.smarthse.radiationTraining.modules.training.entity.training.TrainingPersonCertificate;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.util.List;

/**
 * Description:培训 vo
 *
 * @Author:chuhy
 * @create:2022/3/11 10:09
 */
@Data
public class TrainingDetailVo extends Training {
    private static final Long serialVersionUID = 1285132684177164702L;

    @ApiModelProperty("适用工作类别Vo集合")
    private List<TrainingWorkTypeVo> trainWorkTypeVoList;

    @ApiModelProperty("适用工作类别名称集合")
    private String trainWorkTypeNameList;

    @ApiModelProperty("是否有个人用户报名(0-否；1-是)")
    private Byte hasUserEnroll;

    @ApiModelProperty("是否有单位用户报名(0-否；1-是)")
    private Byte hasUnitEnroll;

    @ApiModelProperty("目标证书名称")
    private String certificateName;

    @ApiModelProperty("课程数")
    private Integer courseNum;

    @ApiModelProperty("培训的 学时数")
    private Double classHourNum;

    @ApiModelProperty("人员类别及证书信息")
    private List<TrainingPersonCertificate> personCertificateList;

    @ApiModelProperty("人员类别名称集合")
    private String personTypeNameList;

    @ApiModelProperty("行业集合")
    private List<TrainingIndustryVo> trainIndustryVoList;

    @ApiModelProperty("行业名称集合")
    private String trainIndustryNameList;

    @ApiModelProperty("是否可修改(0-不可修改；1-可以修改)")
    private Integer isModify = 0;

}
