package cn.smarthse.radiationTraining.modules.training.vo.training;

import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;

/**
 * 用人单位培训档案 Vo
 *
 * @author chuhy
 * @date 2022/9/26
 */
@Data
public class TrainHomeUserVo implements Serializable {
    private static final long serialVersionUID = -4710559651915053628L;

    @ApiModelProperty(value="用户id")
    private Long userId;

    @ApiModelProperty(value="姓名")
    private String name;

    @ApiModelProperty(value="账号")
    private String userName;

    @ApiModelProperty(value="单位名称")
    private String companyName;

    @ApiModelProperty(value="区域名称")
    private String areaName;

    @ApiModelProperty(value="培训次数")
    private Integer trainTimes;

    @ApiModelProperty(value="有效证书数 - 主要负责人证书数")
    private Integer majorCetNum;

    @ApiModelProperty(value="有效证书数 - 职业卫生管理人员证书数")
    private Integer managerCetNum;

    @ApiModelProperty(value="有效证书数 - 小计")
    private Integer totalCetNum;

    public Integer getTotalCetNum() {
        return majorCetNum + managerCetNum;
    }
}
