package cn.smarthse.radiationTraining.modules.training.vo.training;

import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;

import java.util.Date;

/**
 * Description:
 *
 * @Author:chuhy
 * @create:2022/8/29 10:30
 */
@Data
@EqualsAndHashCode(callSuper = false)
public class TrainChangeRecordVo {
    private static final long serialVersionUID = 6274504721551155284L;


    @ApiModelProperty("培训名称")
    private String trainName;

    @ApiModelProperty("报名结束时间")
    private String signEndTime;

    @ApiModelProperty("培训开始时间")
    private String trainStarTime;

    @ApiModelProperty("培训结束时间")
    private String trainEndTime;

    @ApiModelProperty("培训类型")
    private String trainType;

    // (0-不收费；1-收费)
    @ApiModelProperty("是否收费")
    private String isCharge;

    // (0-否；1-是)
    @ApiModelProperty("是否在线考试")
    private String isTestOnline;

    @ApiModelProperty("培训区域id")
    private String trainArea;

    // (-10 不限次数)
    @ApiModelProperty("重考次数限制")
    private String retestLimit;

    // (0-原题重考；1-原题打乱；2-重组试卷)
    @ApiModelProperty("重考设置")
    private String retestSetting;

    // (0-分别考试；1-统一考试)
    @ApiModelProperty("考试方式")
    private String testMode;

    // (1-学院共用；2-随机分配)
    @ApiModelProperty("试卷使用方式")
    private String testPaperUsage;

    // (0-已下架；1-草稿；2-已上架)
    @ApiModelProperty("状态")
    private String status;

    // (0-不需要;1-需要)
    @ApiModelProperty("人脸识别")
    private String isFaceRecognition;

    /** 统一考试  */
    @ApiModelProperty("试卷结构表名称")
    private String paperStructureName;

    @ApiModelProperty("总分")
    private String totalScore;

    @ApiModelProperty("答题时长(分钟)")
    private String testDuration;

    @ApiModelProperty("及格分数")
    private String passingScore;

    // //人员类型是否被修改(0-否；1-是)
    // @ApiModelProperty(value = "人员类型")
    // private Integer isPersonTypeModify;
    // //行业是否被修改(0-否；1-是)
    // @ApiModelProperty(value = "行业")
    // private Integer isIndustryModify;
}
