package cn.smarthse.radiationTraining.modules.training.vo.training;

import com.fasterxml.jackson.annotation.JsonIgnore;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.util.Date;

/**
 * Description:单位用户-我的培训列表 vo
 *
 * @Author:chuhy
 * @create:2022/3/24
 */
@Data
public class CorpMyTrainListVo implements Serializable {
    private static final long serialVersionUID = -4915607368747904777L;

    @ApiModelProperty("培训id")
    private Long id;

    @ApiModelProperty("培训名称")
    private String trainName;

    @ApiModelProperty("证书名称")
    private String certificateName;

    @JsonIgnore
    @ApiModelProperty("适用工作类别Code集合(Code和名称在这里不是一一对应的)")
    private String trainWorkTypeCodeList;

    @ApiModelProperty("适用工作类别名称集合")
    private String trainWorkTypeNameList;

    @ApiModelProperty("人员类型")
    private String personTypeNameList;

    @ApiModelProperty("培训类型")
    private String trainType;

    @ApiModelProperty("单位报名人数")
    private Integer unitEnrollNum;

    @ApiModelProperty("个人报名人数")
    private Integer personEnrollNum;

    @ApiModelProperty("已取证人数")
    private Integer hasCertificateNum;

    @ApiModelProperty("封面url")
    private String coverUrl;

    @ApiModelProperty("状态 (0-退回；1-待培训；2-培训中；4-培训结束；)")
    private Byte trainStatus;



    @ApiModelProperty("课程数")
    private Integer courseNum;

    @ApiModelProperty("培训开始时间")
    private Date trainStarTime;

    @ApiModelProperty("培训结束时间")
    private Date trainEndTime;

    @ApiModelProperty("考试截止时间")
    private Date testEndTime;

    @ApiModelProperty("单位报名id")
    private Long enrollId;
}
