package cn.smarthse.radiationTraining.modules.training.vo.enroll;

import cn.smarthse.radiationTraining.modules.training.entity.enroll.TuEnrollDetail;
import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;
import lombok.experimental.Accessors;

import java.io.Serializable;

/**
 * @ClassName HSECompanyTrainStatusVo
 * @Description 职业健康企业培训状态
 * @Author ChenLiang
 */
@Data
@Accessors(chain = true)
@NoArgsConstructor
@AllArgsConstructor
public class HSECompanyTrainStatusVo implements Serializable {
    @ApiModelProperty("职业健康系统的token")
    private Long hseCompanyToken;
    @ApiModelProperty("培训id")
    private Long tid;


    @ApiModelProperty("总报名人数（主要负责人）")
    private Integer total1;
    @ApiModelProperty("待培训人数（主要负责人）")
    private Integer toBeTraining1;
    @ApiModelProperty("培训中人数人数（主要负责人）")
    private Integer inTrainint1;
    @ApiModelProperty("取证人数人数（主要负责人）")
    private Integer getCertificate1;
    @ApiModelProperty("不合格人数（主要负责人）")
    private Integer trainingCompleted1;

    @ApiModelProperty("总报名人数（职业健康管理员）")
    private Integer total2;
    @ApiModelProperty("待培训人数（职业健康管理员）")
    private Integer toBeTraining2;
    @ApiModelProperty("培训中人数人数（职业健康管理员）")
    private Integer inTrainint2;
    @ApiModelProperty("取证人数人数（职业健康管理员）")
    private Integer getCertificate2;
    @ApiModelProperty("不合格人数（职业健康管理员）")
    private Integer trainingCompleted2;

    @ApiModelProperty("单位培训状态（主要负责人）")
    private Byte status1;
    @ApiModelProperty("单位培训状态（职业健康管理员）")
    private Byte status2;

    public Byte getStatus1() {
        if(toBeTraining1 + inTrainint1 + getCertificate1  +  trainingCompleted1 == 0){
            return 0;//未报名
        }else {
            if(getCertificate1 == 0){
                return 1;//进行中
            }else {
                return 2;//已完成
            }
        }
    }

    public Byte getStatus2() {
        if(toBeTraining2 + inTrainint2 + getCertificate2  +  trainingCompleted2 == 0){
            return 0;//未报名
        }else {
            if(getCertificate2 < total2){
                return 1;//进行中
            }else {
                return 2;//已完成
            }
        }
    }
}
