package cn.smarthse.radiationTraining.modules.training.vo.course;

import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.util.Date;
import java.util.List;

/**
 * @ClassName TuCourseVo
 * @Description 返回给前端 用户课程考试
 * @Author wuxq
 * @ModifyDate 2022/3/31 13:10
 */
@Data
public class TuCourseVo implements Serializable {

    @ApiModelProperty("tu_course_id")
    private Long id;

    @ApiModelProperty("trainingCourseId")
    private Long trainingCourseId;

    @ApiModelProperty("课程名称")
    private String name;

    @ApiModelProperty("试卷名称")
    private String structName;

    @ApiModelProperty("考试时长（分钟）")
    private Integer testDuration;

    @ApiModelProperty("总分数")
    private Integer totalScore;

    @ApiModelProperty("及格分数")
    private Integer passingScore;

    @ApiModelProperty("总题数")
    private Integer questionNum;

    @ApiModelProperty("是否必过：0-否；1-是；")
    private Integer mustPass;

    @ApiModelProperty("是否考试：0-否；1-是；")
    private Integer mustTest;

    @ApiModelProperty("考试状态：0-待考试；1-未通过；2-已通过")
    private Integer isPassed;

    @ApiModelProperty("当前分数")
    private Integer currentScore;

    @ApiModelProperty("剩余考试次数")
    private Integer remainderExam;

    @ApiModelProperty("课程学习状态：0-未学习；1-学习中；2-已完成；")
    private Integer learnStatus;

}
