package cn.smarthse.radiationTraining.modules.training.provider.training;


import cn.smarthse.radiationTraining.core.framework.model.LayuiGridData;
import cn.smarthse.radiationTraining.core.framework.model.ResponseData;
import cn.smarthse.radiationTraining.modules.training.param.enroll.PersonEnrollCourseParam;
import cn.smarthse.radiationTraining.modules.training.param.enroll.PersonEnrollSearchParam;
import cn.smarthse.radiationTraining.modules.training.param.training.TrainingSearchParam;
import cn.smarthse.radiationTraining.modules.training.param.training.UserMyTrainSearchParam;
import cn.smarthse.radiationTraining.modules.training.vo.course.CourseItemVo;
import cn.smarthse.radiationTraining.modules.training.vo.course.TuCourseExamCountVo;
import cn.smarthse.radiationTraining.modules.training.vo.training.*;

import java.util.List;

/**
 * @ClassName ITrainingProviderServiceForUser
 * @Description 对外个人用户培训接口(与微信接口共用)
 * @Author chuhy
 * @Date 2022/3/24
 */
public interface ITrainingProviderServiceForUser {

    /**
     * WX个人用户-培训基础信息
     *
     * @param tid 培训ID
     * @param uid 登录用户Id
     * @return  TrainingBaseInfoVo
     * @author  chuhy
     */
    TrainingBaseInfoVo getMyTrainingBaseInfoForWx(Long tid, Long uid, Long enrollDetailId);

    /**
     * 获取报名所需信息
     * @param tid
     * @return (培训模式、人员类型)
     */
    TrainingBaseInfoVo getEnrollNeededInfo(Long tid);

    /**
     * 搜索单位-APP
     * @param companyName 公司名称
     * @return {@link LayuiGridData< TrainingListVo>}
     * @author chuhy
     * @date 2023/4/4 14:08
     */
    LayuiGridData<WxCompanyListVo> searchCompanyList(String companyName, Integer pageNum, Integer pageSize);

    /**
     * 查看可报名列表
     * @param param 公司areaId、直属类型
     * @return {@link LayuiGridData< TrainingListVo>}
     * @author chuhy
     * @date 2023/4/4 14:08
     */
    LayuiGridData<TrainingListVo> getCouldEnrollList(TrainingSearchParam param);

    /**
     * 查看可报名培训-详情
     * @param param 公司areaId、直属类型
     * @return {@link LayuiGridData< TrainingListVo>}
     * @author chuhy
     * @date 2023/4/4 14:08
     */
    TrainingListVo getCouldEnrollInfo(TrainingSearchParam param);

    /**
     * 查看可报名列表
     * @param tid 培训id
     * @author chuhy
     */
    List<WxTrainCourseGroupVo> getTrainCourseListForWx(Long tid);

    // ForUser-------------------------------------------------------------------------------
    /**
     * 登陆后-培训列表分页 数据
     * @param param 培训搜索参数
     * @return 培训列表Vo
     * @Author chuhy
     */
    LayuiGridData<TrainingListVo> getTrainingPageListForUser(TrainingSearchParam param);

    /**
     * 登录后-培训基础信息
     *
     * @param tid 培训ID
     * @param uid 登录用户Id
     * @return  UserMyTrainListVo
     * @author  chuhy
     */
    UserMyTrainListVo getTrainingBaseInfoForUser(Long tid, Long uid);

    /**
     * 登录后-课程组 数据
     * @param tid 培训Id
     * @param uid 登录用户Id
     * @return 培训-课程组Vo
     * @Author chuhy
     */
    List<TrainingCourseGroupVo> getTrainingCourseGroup(Long tid, Long uid);

    /**
     * 登录后-课程组-课程 数据
     * @param tid 培训Id
     * @param courseGroupId 课程组Id
     * @return 课程Vo
     * @Author chuhy
     */
    List<UserMyTrainCourseVo> getTrainingCourse(Long tid, Long uid, Long courseGroupId);

    /**
     * 个人中心-各培训状态的数量
     * @param uid
     * @return
     */
    List<UserTrainStatusNumVo> getTrainingStatusNumListForUser(Long uid);

    /**
     * 个人用户-培训基础信息
     *
     * @param tid 培训ID
     * @param uid 登录用户Id
     * @return  UserMyTrainListVo
     * @author  chuhy
     */
    SysUserTrainInfoVo getMyTrainingBaseInfoForUser(Long tid, Long uid, Long enrollDetailId);

    /**
     * 个人用户中心-我的培训 培训列表分页 数据
     * @param param 个人用户-我的培训 搜索参数
     * @return 培训列表Vo
     * @Author chuhy
     */
    LayuiGridData<UserMyTrainListVo> getMyTrainPageListForUser(UserMyTrainSearchParam param);

    /**
     * 个人用户中心-我的课程 课程组 数据
     * @param tid 培训Id
     * @return 培训-课程组Vo
     * @Author chuhy
     */
    List<TrainingCourseGroupVo> getMyTrainingCourseGroup(Long tid, Long uid);

    /**
     * 个人用户中心-我的课程-课程组-课程 数据
     * @param tid 培训Id
     * @param courseGroupId 课程组Id
     * @return 课程Vo
     * @Author chuhy
     */
    List<UserMyTrainCourseVo> getMyTrainingCourse(Long tid, Long uid, Long courseGroupId);

    /**
     * 删除退回状态的培训
     * @param tid 培训Id
     * @param uid 用户登录Id
     * @return
     * @Author chuhy
     */
    void delTrainingForUser(Long tid, Long uid);

    /**
     * 查询所有已报名培训的工作类别,用于搜索时的工作类别下拉列表
     * @param uid 个人用户Id
     * @return 工作类别Vo
     * @Author chuhy
     */
    List<TrainingWorkTypeVo> getTrainingWorkType(Long uid);


    /**
     * 课程
     */
    List<CourseItemCatalogueVo> getCourseCataSubLogue(Long GroupId, Long loginUserId);
    /**
     * 方法描述:  个人中心-我的考试
     *
     * @param   param
     * @return  LayuiGridData<UserMyTrainListVo>
     * @author  wuxq
     * @date    2022/3/30
     */
    LayuiGridData<UserMyTrainListVo> getMyTrainingExamPageList(UserMyTrainSearchParam param);

    /**
     * 方法描述:  查询培训基础信息
     *
     * @param   id 报名详情id
     * @return  UserMyTrainListVo
     * @author  wuxq
     * @date    2022/3/30
     */
    UserMyTrainListVo getTrainingBaseInfo(Long id);

    /**
     * 在培训时间范围内，获取课程详情
     * @param traningCourseId
     * @return
     */
    ResponseData<TrainingCourseItemVo> getCourseItemDetailForMajor(Long traningCourseId, Long tuCoruseId);
    /**
     * @description 精准培训课程详情
     * @param tuCoruseId
     * @return
     * @author chenliang
     * @date 2022/10/31 08:52:09
     */
    ResponseData<TrainingCourseItemVo> getCourseItemDetailForPrecise(Long tuCoruseId);
    /**
     * 获取课程学习状态
     * @return
     */
    TraningProgressVo getTraningProgress(Long tuEnrollDetailId);

    /**
     * 方法描述:  个人中心-我的考试 培训考试列表统计
     *
     * @param   loginUserId 当前登录人id
     * @return  TrainingExamCountVo
     * @author  wuxq
     * @date    2022/4/8
     */
    TrainingExamCountVo getTrainingExamCount(Long loginUserId);


    /**
     * 系统管理-个人用户详情-查看培训列表
     * @param param 查询参数
     * @author chuhy
     */
    LayuiGridData<TrainingPersonEnrollVo> listPersnoEnroll(PersonEnrollSearchParam param);

    /**
     * 系统管理-个人用户详情-查看已报名培训课程列表
     * @param param 查询参数
     * @author chuhy
     */
    LayuiGridData<TrainEnrollCourseVo> listPersnoEnrollCourse(PersonEnrollCourseParam param);

    /**
     * 个人学习列表页面进入考试前的弹窗信息
     * @param tuCourseId
     * @return
     */
    ExamAlertInfoVo getExamAlertInfo(Long tuCourseId);


    /**
     * 获取培训基础目录
     * @param tid
     * @return {@link List< CourseGroupCatalogueVo>}
     * @author chenliang
     * @date 2023/4/6 13:20
     */
    List<CourseGroupCatalogueVo> getBaseCourseCataLogue(Long tid);

    /**
     * 获取课程详情
     * @param tuCoruseId
     * @return {@link  ResponseData<TrainingCourseItemVo>}
     * @author chenliang
     * @date 2023/4/6 13:20
     */
    ResponseData<TrainingCourseItemVo> getCourseItem(Long tuCoruseId);

}
