package cn.smarthse.radiationTraining.modules.training.provider.training;


import cn.smarthse.radiationTraining.core.framework.model.LayuiGridData;
import cn.smarthse.radiationTraining.modules.training.entity.training.TrainingCourse;
import cn.smarthse.radiationTraining.modules.training.param.training.*;
import cn.smarthse.radiationTraining.modules.training.vo.course.CourseItemVo;
import cn.smarthse.radiationTraining.modules.training.vo.training.TrainingCourseGroupVo;
import cn.smarthse.radiationTraining.modules.training.vo.training.TrainingCourseVo;
import cn.smarthse.radiationTraining.modules.training.vo.training.TrainingNewCourseGroupVo;
import cn.smarthse.radiationTraining.modules.training.vo.training.UserMyTrainCourseVo;

import java.util.List;

/**
 * @ClassName ITrainingProviderService
 * @Description 对外培训-(课程、课程组)相关接口
 * @Author chuhy
 * @Date 2022/3/16
 */
public interface ITrainingCourseProviderService {

    // 一次性请求---------------------------------------------------------------------------------------------------------------
    /**
     * 查看培训-课程列表
     * @param param 培训搜索参数
     * @return 课程列表Vo
     * @Author chuhy
     */
    LayuiGridData<TrainingNewCourseGroupVo> getNewTrainCourse(TrainingSearchParam param);

    /**
     * 查看培训-课程列表(不分页)
     * @param param 培训搜索参数
     * @return 课程列表Vo
     * @Author chuhy
     */
    List<TrainingNewCourseGroupVo> getNewTrainCourseList(TrainingSearchParam param);

    /**
     * 保存培训-课程列表-课程信息
     * @param param 新增课程信息参数
     * @return
     * @Author chuhy
     */
    void saveOrUpdateNewTrainCourse(AddNewTrainCourseGroupParam param);

    /**
     * 获取统一考试在培训课程里冗余的试卷结构信息
     * @param tid
     * @author chuhy
     */
    TrainingCourse getPaperInfoByTid(Long tid);

    /**
     * 获取新的课程，用于更新冗余数据
     * @param courseId 课程id
     * @author chuhy
     */
    CourseItemVo getNewCourseInfo(Long courseId);

    /**
     * 删除培训课程缓存
     */
    String delTrainCourseRedis();

    /**
     * 将课程组老数据添加至冗余数据中
     * @return String
     * @author chuhy
     * @date 2022/12/12 9:08
     */
    String modifyOldTrainCourseGroup();

    // ---------------------------------------------------------------------------------------------------------------


    /**
     * 方法描述: 根据id查询
     *
     * @param   trainingCourseId id
     * @return  TrainingCourse
     * @author  wuxq
     * @date    2022/3/28
     */
    TrainingCourse getById(Long trainingCourseId);

    /**
     * 根据培训id，获取课程id集合 用于统一考试
     * @param tid 培训id
     * @return 课程id集合
     * @Author chuhy
     */
    List<String> getCourseIdListByTid(Long tid);

    /**
     * 根据培训id，获取该培训下所有课程的危害因素
     * @param tid 培训id
     * @return 危害因素code集合
     * @Author chuhy
     */
    List<String> getRiskFactorListByTid(Long tid);

    // ForApi---------------------------------------------------------------------------------------------------------------
    List<TrainingCourseGroupVo> getTrainingCourseGroupForApi(Long tid);

    List<TrainingCourseVo> getTrainingCourseForApi(Long tid,Long courseGroupId);
}
