package cn.smarthse.radiationTraining.modules.training.provider.enroll;

import cn.smarthse.radiationTraining.core.framework.model.LayuiGridData;
import cn.smarthse.radiationTraining.modules.training.entity.enroll.TuEnroll;
import cn.smarthse.radiationTraining.modules.training.entity.enroll.TuEnrollDetail;
import cn.smarthse.radiationTraining.modules.training.param.enroll.*;
import cn.smarthse.radiationTraining.modules.training.param.training.TrainEnrollDetailOptBatchParam;
import cn.smarthse.radiationTraining.modules.training.param.training.TrainEnrollOptBatchParam;
import cn.smarthse.radiationTraining.modules.training.vo.course.EnrollInfoVo;
import cn.smarthse.radiationTraining.modules.training.vo.enroll.*;

import java.util.List;

/**
 * @ClassName ITrainingProviderService
 * @Description 对外 报名接口
 * @Author wuxq
 * @Date 2022/3/18
 */
public interface ITuEnrollProviderService {

    void personalSignUpByQRCode(PersonalEnrollParam param);

    void personalSignUpByIndividual(PersonalEnrollParam param);

    /**
     * @description 单位选择培训报名
     * @param param
     * @return cn.smarthse.radiationTraining.modules.training.entity.enroll.TuEnroll
     * @author chenliang
     * @date 2022/8/10 13:29:58
     */
    TuEnroll enroll(CropSelectTraninglParam param);

    /**
     * 补充发证单位冗余数据
     * @author chenliang
     * @date 2023/3/20 15:46
     */
    void putIssueUnitName();

    /**
     * @description 统计单位报名次数
     * @param cidList
     * @return
     * @author chenliang
     * @date 2022/9/14 14:18:34
     */
    List<EnrollNumberVo> getEnrollCount(List<Long> cidList);
    /**
     * @description 生成报名二维码
     * @param param
     * @return java.lang.String
     * @author chenliang
     * @date 2022/8/10 13:30:16
     */
    EnrollQRCodeVo generateQRCodeContent(GenerateEnrollQRCodeParam param);
    EnrollQRCodeVo getQRCodeContent(GenerateEnrollQRCodeParam param);
    /**
     * @description: 解析二维码
     * @author: chenliang
     * @date: 2023/6/12 9:25
     * @param: qrcode
     * @return: java.lang.String
     */
    String parsingQRCode(String qrcode);

    /**
     * 管理员删除用户报名信息
     *
     * @param param
     */
    void adminToDeletePersonalEnrollDetail(AdminToRemoveStaffParam param);



    /**
     * 管理员删除单位报名
     *
     * @param param
     */
    void adminToDeleteEnroll(AdminToRmCropEnrollParam param);




    /**
     * 搜索报名清单
     *
     * @param param
     * @return
     */
    LayuiGridData<EnrollInfoVo> searchEnrollList(SearchRegListParam param);


    /**
     * 单位批量退回报名
     *
     * @param paramList
     */
    void cropToSendBackBatch(List<SendBackParam> paramList);

    /**
     * 单位退回报名
     *
     * @param param
     */
    void cropToSendBack(SendBackParam param);

    /**
     * 退回单位报名
     *
     * @param param
     */
    void adminTosendBackCrop(AdminToSendBackCropParam param);

    /**
     * 管理员退回用户报名
     *
     * @param param
     */
    void adminToSendBack(AdminToSendBackParam param);





    /**
     * 培训管理-个人报名批量操作
     *
     * @param param
     */
    List<EnrollOptVo> enrollDetailOptBath(List<TrainEnrollDetailOptBatchParam> param);


    /**
     * 培训管理 用户报名列表批量操作
     *
     * @param paramList
     */
    void enrollOptBath(List<TrainEnrollOptBatchParam> paramList);


    void cropToDeleteStaff(RemoveStaffParam param);

    /***
     * @description 单位删除整个单位报名
     * @param param
     * @return void
     * @author chenliang
     * @date 2022/7/4 10:28:31
     */
    void cropToDeleteOneEnroll(CropDeleteOneEnrollParam param);

    /**
     * 查看员工培训详情
     *
     * @param param
     * @return
     */
    LayuiGridData<StaffTrainingDetailVo> getStaffTrainingDetail(SearchStaffTrainingDetailParam param);

    /**
     * 批量删除
     *
     * @param paramList
     */
    void cropTodeleteStaffBatch(List<RemoveStaffParam> paramList);


    /**
     * 更新所有报名状态
     */
    void upateAllEnrollStatus();


    /**
     * 根据id获取报名详情
     * @param enrollDetailId
     * @return
     */
    TuEnrollDetail getEnrollDetailById(Long enrollDetailId);


    /**
     * @description 更新冗余信息（不包括单位信息）
     * @param param
     * @return void
     * @author chenliang
     * @date 2022/9/29 09:34:02
     */
    void updateRedundancyExcludeUintInfo(UpRedundancyInfoParam param);

    /**
     * @description 更新单位冗余信息
     * @param param
     * @return void
     * @author chenliang
     * @date 2022/9/29 09:34:02
     */
    void updateUnitRedundancyInfo(UpRedundancyInfoParam param);

    /**
     * @description 同步职业健康状态数据
     *
     * @return java.lang.String
     * @author chenliang
     * @date 2022/10/17 20:41:24
     */
    String syncHSECompanyTrainStatus();

    /**
     * @description 析企业在职业健康系统中的培训状态
     *
     * @return cn.smarthse.radiationTraining.modules.training.vo.enroll.HSECompanyTrainStatusVo
     * @author chenliang
     * @date 2022/10/17 16:53:59
     */
    List<HSECompanyTrainStatusVo> analyseHSEComapnyTrain();

    /**
     * @description 重新建立员工公司联系
     * @param pwd
     * @return void
     * @author chenliang
     * @date 2022/10/10 14:08:33
     */
    void reBuildAllRelationship(String pwd);


    /**
     * @description 报名数据恢复
     * @param param
     * @return void
     * @author chenliang
     * @date 2022/11/11 09:28:30
     */
    void resurgenceData(ResurgenceEnrollDataParam param);

    /**
     * 删除报名信息（包括学习、证书记录）
     * @param param
     * @author chenliang
     * @date 2023/4/6 14:29
     */
    void staffToRmEnrollInfo(RemoveEnrollInfoParam param);

    void syncSingleCropEnrollInfo(Long enrollId);
}
