package cn.smarthse.radiationTraining.modules.training.provider.course;

import cn.smarthse.radiationTraining.core.framework.model.LayuiGridData;
import cn.smarthse.radiationTraining.core.framework.model.ResponseStateEnum;
import cn.smarthse.radiationTraining.modules.training.entity.course.CourseItem;
import cn.smarthse.radiationTraining.modules.training.param.course.*;
import cn.smarthse.radiationTraining.modules.training.vo.course.ClassHourstatisticsVo;
import cn.smarthse.radiationTraining.modules.training.vo.course.CourseGroupVo;
import cn.smarthse.radiationTraining.modules.training.vo.course.CourseItemBatchOptVo;
import cn.smarthse.radiationTraining.modules.training.vo.course.CourseItemVo;

import java.util.List;

/**
 * 课程管理
 */
public interface ICourseItemManagerProviderService {
    /**
     * 根据关键词分页查询课程组
     * @param param
     * @return
     */
    LayuiGridData<CourseItemVo> searchItemsByKeyword(CoursePageParam param);

    /**
     * 根据id获取课程
     * @param courseItemId
     * @return
     */
    CourseItemVo getCourseItemById(Long courseItemId);

    /**
     * 方法描述:  根据培训关联课程id查询
     *
     * @param   trainCourseId 培训关联课程id
     * @return  CourseItemVo
     * @author  wuxq
     * @date    2022/3/28
     */
    CourseItemVo getByTrainCourseId(Long trainCourseId);

    /**
     * 一次性编辑课程
     */
    void editFullCourseItemInfo(CourseItemEditFullInfoParam param);



    /**
     * 添加课程
     * @param param
     * @return
     */
    void addCourseItem(CourseItemAddParam param);

//    /**
//     * 插入课程
//     * @param param
//     * @return
//     */
//    boolean insertCourseItem(CourseItemAddParam param);

    /**
     * 改变课程顺序
     * @param paramList
     * @return
     */
    void rearrangement(List<RearrangementParam> paramList);

    /**
     * 删除课程
     */
    void delete(Long courseItemId);

    /**
     * 批量操作
     */
    List<CourseItemBatchOptVo> batchOpt(List<CourseItemSingleOptParam> paramList);

    List<CourseItemVo> matchCourse(MatchCourseParam param);

    /**
     * @description 检查是否有编辑权限
     * @param checkParam
     * @return void
     * @author chenliang
     * @date 2022/9/5 10:02:36
     */
    void checkOneEditPermission(CheckEditPermissionParam checkParam);
    /**
     * @description 检查是否有编辑权限
     * @param checkParam
     * @return void
     * @author chenliang
     * @date 2022/9/5 10:02:36
     */
    void checkBatchEditPermission(CheckEditPermissionParam checkParam);

    /**
     * @description 课时统计(v1)
     * @param param 统计条件
     * @return java.lang.Long
     * @author chenliang
     * @date 2022/10/10 09:37:53
     */
     ClassHourstatisticsVo countClassHoursV1(ClassHourStatisticsParam param);
    /**
     * @description 课时统计(v3.2.2.1)
     * @param param 统计条件
     * @return java.lang.Long
     * @author chenliang
     * @date 2022/10/10 09:37:53
     */
    List<ClassHourstatisticsVo> countClassHoursV3_2_2_1(ClassHourStatisticsParam param);

//    /**
//     * 批量插入课程
//     * @param paramList
//     */
//    void insertCourseItemBatch(List<CourseItemAddParam> paramList);

}
