package cn.smarthse.radiationTraining.modules.training.provider.course;

import cn.smarthse.radiationTraining.core.framework.model.LayuiGridData;
import cn.smarthse.radiationTraining.modules.training.param.CheckEditPermissionParam;
import cn.smarthse.radiationTraining.modules.training.param.course.*;
import cn.smarthse.radiationTraining.modules.training.vo.course.CourseGroupBatchOptVo;
import cn.smarthse.radiationTraining.modules.training.vo.course.CourseGroupVo;
import cn.smarthse.radiationTraining.modules.training.vo.course.CourseWorkTypeVo;

import java.util.List;
import java.util.Set;

/**
 * 课程管理服务
 */
public interface ICourseGroupManagerProviderService {

    void pptt();

    /**
     * 根据关键词分页查询课程组
     * @param param
     * @return
     */
    LayuiGridData<CourseGroupVo> searchGroupsByKeyword(GroupPageParam param);
    List<CourseGroupVo> getIdsAndNamesByKeyword(String keyword);




    /**
     * 根据id查看组详情
     * @param id
     * @return
     */
    CourseGroupVo getGroupDetailById(Long id);

    /**
     * 添加组
     * @param param
     * @return
     */
    boolean addGroup(CourseGroupAddParam param);

    /**
     * 添加组
     * @param param
     * @return
     */
    void addCourseItem(GroupAddItemsParam param);

    /**
     * 更新组
     * @param param
     * @return
     */
    boolean editGroup(CourseGroupEditParam param);

    /**
     * 改变状态
     * @param
     * @return
     */
    boolean editGroupStatus(CourseGroupChangeStatusParam param);

    boolean delete(Long id);

    /**
     * 通过组id预览
     * @param id
     * @return
     */
    CourseGroupVo previewByGroupId(Long id);

    /**
     * 通过课程id预览
     * @param id
     * @return
     */
    List<CourseGroupVo> previewByItemId(Long id);

    /**
     * 批量操作
     * @param paramList
     * @return
     */
    List<CourseGroupBatchOptVo> batchOpt(List<CourseGroupSingleOptParam> paramList);



    /**
     * 组删除课程联系
     * @param param
     */
    void deleteCoruseItem(GroupDeleteItemParam param);
    void deleteCoruseItemBatch(List<GroupDeleteItemParam> paramList);

    /**
     * @description 检查编辑权限
     * @return void
     * @author chenliang
     * @date 2022/9/5 10:25:25
     */
    void checkEditPermission(CheckEditPermissionParam param);

    /**
     * @description 检查编辑权限
     * @param uid
     * @param uname
     * @param groupIdList
     * @return void
     * @author chenliang
     * @date 2022/9/5 10:25:25
     */
    void checkEditPermission(Long uid, String uname,Integer userFrom, Integer userOptRole, List<Long> groupIdList);

    /**
     * @description: 获取默认课程组
     * @author: chenliang
     * @date: 2023/6/8 13:19
     * @param:
     * @return: java.util.List<cn.smarthse.radiationTraining.modules.training.vo.course.CourseGroupVo>
     */
    List<CourseGroupVo> getDefaultCourse();

}
