package cn.smarthse.radiationTraining.modules.training.param.training;

import cn.smarthse.radiationTraining.core.framework.model.PageParam;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;

/**
 * 个人中心-我的培训 查询参数对象
 *
 * @author chuhy
 * @date
 */
@Data
@EqualsAndHashCode(callSuper = false)
public class UserMyTrainSearchParam extends PageParam {

    private static final Long serialVersionUID = -110319853688507878L;

    @ApiModelProperty(value = "用户ID",hidden = true)
    private Long uid;

    @ApiModelProperty("培训ID")
    private Long tid;

    @ApiModelProperty("适用工作类别code")
    private String workType;

    @ApiModelProperty("培训状态(0-退回；1-待培训；2-培训中；3-已取证；4-培训结束)")
    private Byte status;

    @ApiModelProperty("学习状态(0-学习未完成；1-全部)")
    private Byte studyStatus;

    @ApiModelProperty("是否只获取一个工作类别(0-否；1-是)")
    private Integer isGetOneWorkType;

    @ApiModelProperty(value = "不要返回退回的培训(小程序接口不需要)(0-返回；1-不返回)",hidden = true)
    private Integer isGetBackTrain;

    @ApiModelProperty(value = "是否展示不需要考试(0-否；1-是)")
    private Integer isGetTest;

}
