package cn.smarthse.radiationTraining.modules.training.param.training;

import cn.smarthse.radiationTraining.core.framework.model.PageParam;
import cn.smarthse.radiationTraining.core.framework.model.UserEditParam;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;

import java.util.Date;
import java.util.List;

/**
 * 培训清单列表参数对象
 *
 * @author chuhy
 * @date 2022/9/7
 */
@Data
@EqualsAndHashCode(callSuper = false)
public class TrainHomeListParam extends PageParam {

    private static final Long serialVersionUID = -110319853688501078L;

    @ApiModelProperty(value = "用户ID",hidden = true)
    private Long uid;

    @ApiModelProperty(value = "查询类型(1-未培训; 2-已培训未考试; 3-已培训已考试通过)")
    private Integer type;

    @ApiModelProperty(value = "培训时间年份")
    private Integer year;
}
