package cn.smarthse.radiationTraining.modules.training.param.training;

import cn.smarthse.radiationTraining.core.framework.model.PageParam;
import cn.smarthse.radiationTraining.core.framework.utils.StringUtils;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;

import java.util.List;

/**
 * 培训清单列表参数对象
 *
 * @author chuhy
 * @date 2022/9/22
 */
@Data
@EqualsAndHashCode(callSuper = false)
public class TrainHomeCropParam extends PageParam {

    private static final long serialVersionUID = -5963422862346076275L;

    @ApiModelProperty(value = "用户区域",hidden = true)
    private Long userArea;

    @ApiModelProperty(value = "用户区域level",hidden = true)
    private int userAreaLevel;

    @ApiModelProperty(value = "行业")
    private List<IndustryCodeParam> industryCodeList;

    @ApiModelProperty(value = "主要负责人证书状态(0-未取证；1-证书过期；2-证书有效)")
    private Integer majorStatus;

    @ApiModelProperty(value = "职业卫生管理人员证书状态(0-未取证；1-全部过期；2-部分过期；3-全部有效)")
    private Integer managerStatus;

    /**
     * 是否职业健康在线企业（在职业健康在线监管端可见的企业）
     */
    @ApiModelProperty(value = "是否职业健康在线企业(0-否；1-是)")
    private Integer isHseCompany;

    /**
     * 未开始：企业主要负责人有效证书数为0，但是还未有主要负责人报名培训；
     * 进行中：企业主要负责人有效证书数为0，且当前参加培训的主要负责人培训尚在进行中（有主要负责人报名培训到取证前）
     * 已完成：企业主要负责人有效证书数不为0，且当前参加培训的主要负责人全部都已取证
     */
    @ApiModelProperty(value = "主要负责人-培训状态(0-未开始；1-进行中；2-已完成)")
    private Integer majorTrainStatus;

    /**
     * 未开始：企业职业卫生管理人员有效证书数为0，但是还未有职业卫生管理人员报名培训；
     * 进行中：有管理人员处于培训中；
     * 已完成：企业职业卫生管理人员有效证书数不为0，且当前参加培训的职业卫生管理人员全部都已取证
     */
    @ApiModelProperty(value = "职业卫生管理人员-培训状态(0-未开始；1-进行中；2-已完成)")
    private Integer managerTrainStatus;


    @ApiModelProperty(value = "是否为指定账号",hidden = true)
    private Boolean isSpecifiedUser = false;

    public int getUserAreaLevel() {
        return StringUtils.getAreaLevel(this.userArea);
    }
}
