package cn.smarthse.radiationTraining.modules.training.param.training;

import cn.smarthse.radiationTraining.core.framework.model.PageParam;
import cn.smarthse.radiationTraining.core.framework.utils.StringUtils;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;

/**
 * 培训清单列表参数对象
 *
 * @author chuhy
 * @date 2022/9/22
 */
@Data
@EqualsAndHashCode(callSuper = false)
public class TrainHomeCetParam extends PageParam {

    private static final long serialVersionUID = 6980143807050742191L;

    @ApiModelProperty(value = "监管用户区域",hidden = true)
    private Long userArea;

    @ApiModelProperty(value = "用户区域level",hidden = true)
    private int userAreaLevel;

    @ApiModelProperty(value = "用户id")
    private Long userId;

    @ApiModelProperty(value = "证书类型(200001-主要负责人证书;200002-职业卫生管理人员证书)")
    private String cetType;

    public int getUserAreaLevel() {
        return StringUtils.getAreaLevel(this.userArea);
    }
}
