package cn.smarthse.radiationTraining.modules.training.param.training;

import cn.smarthse.radiationTraining.core.framework.model.UserEditParam;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.experimental.Accessors;

import java.io.Serializable;

/**
 * @ClassName TrainingEnrollOptBatchParam
 * @Description 培训管理-用户报名列表批量操作
 * @Author ChenLiang
 * @ModifyDate 2022/4/13 8:18
 */
@Data
@Accessors(chain = true)
public class TrainEnrollDetailOptBatchParam extends UserEditParam implements Serializable {

    private static final long serialVersionUID = -7494648493780740543L;

    @ApiModelProperty("操作类型 0退回 1删除 2生成证书")
    private byte type;
    @ApiModelProperty(value = "用户报名id")
    private Long enrollDetailId;
    @ApiModelProperty(value = "操作账号名称",hidden = true)
    private String optName;

    @ApiModelProperty(value = "操作账号类别",hidden = true)
    private Integer optUserType;
    @ApiModelProperty(value = "运维用户角色（0-管理员；1-中级；3-基础）",hidden = true)
    private Integer operationRole;
    @ApiModelProperty(value = "对应职业健康的账号id",hidden = true)
    private Long token;


}
