package cn.smarthse.radiationTraining.modules.training.param.training;

import cn.smarthse.radiationTraining.core.framework.model.UserEditParam;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;

import java.util.Date;
import java.util.List;

/**
 * 培训新增参数对象
 *
 * @author chuhy
 * @date
 */
@Data
@EqualsAndHashCode(callSuper = false)
public class PersonTypeCertificateAddParam extends UserEditParam {

    private static final Long serialVersionUID = -110319853688505214L;

    @ApiModelProperty("id")
    private Long id;

    @ApiModelProperty("培训id")
    private Long tid;

    @ApiModelProperty("人员类型")
    private Integer personType;

    @ApiModelProperty("人员类型名称")
    private String personTypeName;

    @ApiModelProperty("证书背景id")
    private Long backgroundId;

    @ApiModelProperty("证书背景名称")
    private String backgroundName;

    @ApiModelProperty("姓名(展示)")
    private String name;
    
    @ApiModelProperty("性别(展示)")
    private String sex;

    @ApiModelProperty("证书编号(展示)")
    private String certificateNo;

    @ApiModelProperty("发证单位(展示)")
    private String awardUnit;

    @ApiModelProperty("证书有效期(年)(展示)")
    private Integer validityDate;

    @ApiModelProperty("身份证(0-不展示；1-展示)")
    private String idCard;

    @ApiModelProperty("工作单位(0-不展示；1-展示)")
    private Integer workUnit;

    @ApiModelProperty("培训时间(0-不展示；1-展示)")
    private Integer trainTime;

    @ApiModelProperty("资格证书编号(0-不展示；1-展示)")
    private Integer qualificationCertNo;

    @ApiModelProperty("培训课程(0-不展示；1-展示)")
    private Integer trainCourse;

    @ApiModelProperty("复审日期(月)")
    private Integer reviewDate;

    @ApiModelProperty("电子章url")
    private String electronicSeal;

    @ApiModelProperty("标志数组(用于前端判断是否勾选)")
    private String isSelectList;

    @ApiModelProperty("精准培训 - 目标学时")
    private Double targetClassHour;

    @ApiModelProperty("精准培训 - 通用课程学时")
    private Double generalClassHour;
}
