package cn.smarthse.radiationTraining.modules.training.param.enroll;

import cn.smarthse.radiationTraining.core.framework.model.PageParam;
import cn.smarthse.radiationTraining.core.framework.model.UserEditParam;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.experimental.Accessors;

import java.io.Serializable;

/**
 * @ClassName SearchRegListParam
 * @Description 报名清单搜索参数
 * @Author ChenLiang
 * @ModifyDate 2022/3/28 10:17
 */

@Data
@Accessors(chain = true)
public class SearchRegListParam extends PageParam implements Serializable {
    @ApiModelProperty(value = "当前登录账号id",hidden = true)
    private Long loginUserId;

    @ApiModelProperty(value = "公司id",hidden = true)
    private Long cid;

    @ApiModelProperty(value = "进度（0：学习未完成，1：考试未完成）")
    private Long progress;

    @ApiModelProperty(value = "培训id")
    private Long tid;

    @ApiModelProperty(value = "1-培训清单 7-审核不通过清单")
    private Integer state;

    @ApiModelProperty(value = "0-退回；1-待培训；2-培训中；3-已取证；4-培训结束 5-待报名")
    private Integer trainingStatus;
}
