package cn.smarthse.radiationTraining.modules.training.param.enroll;

import cn.smarthse.radiationTraining.core.framework.model.PageParam;
import com.fasterxml.jackson.annotation.JsonIgnore;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;

/**
 * 个人用户-培训列表 查询参数对象
 *
 * @author chuhy
 * @date
 */
@Data
@EqualsAndHashCode(callSuper = false)
public class PersonEnrollSearchParam extends PageParam {
    private static final long serialVersionUID = -3972230786556344333L;


    @ApiModelProperty(value = "用户id")
    private Long uid;

    @ApiModelProperty("培训ID")
    private Long tid;

    @ApiModelProperty("单位ID")
    private Long cid;

    @ApiModelProperty("是否考试未完成")
    private Integer isIncompleteTest;

    @ApiModelProperty("是否培训未完成")
    private Integer isIncompleteTrain;

    @ApiModelProperty("状态(0-退回；1-待培训；2-培训中；3-已取证；4-培训结束)")
    private Byte status;

    @ApiModelProperty("适用工作类别")
    private String workType;

    @ApiModelProperty("人员类型")
    private String personType;

    @ApiModelProperty(hidden = true,value = "用于标记搜索框的内容是否为身份证号")
    private Byte isIdCard;

    @ApiModelProperty(value = "是否为指定账号",hidden = true)
    private Boolean isSpecifiedUser = false;

}
