package cn.smarthse.radiationTraining.modules.training.param.enroll;

import cn.smarthse.radiationTraining.core.framework.model.UserEditParam;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.experimental.Accessors;

import java.io.Serializable;

/**
 * @ClassName CropStaffSignUpParam
 * @Description 企业给员工报名的信息参数
 * @Author ChenLiang
 * @ModifyDate 2022/3/25 8:21
 */
@Data
@Accessors(chain = true)
public class CropStaffSignUpParam extends UserEditParam implements Serializable {
    @ApiModelProperty(value = "培训id")
    private Long tid;

    @ApiModelProperty(value = "公司id", hidden = true)
    private Long cid;

    @ApiModelProperty(value = "主表id", hidden = true)
    private Long enrollId;

    @ApiModelProperty(value = "培训从表id")
    private Long enrollDetailId;

    @ApiModelProperty(value = "邮箱", hidden = true)
    private String eamil;

    @ApiModelProperty(value = "身份证", hidden = true)
    private String idCard;

}
