package cn.smarthse.radiationTraining.modules.training.param.enroll;

import cn.smarthse.radiationTraining.core.framework.model.PageParam;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;

/**
 * 单位用户-报名人员列表 查询参数对象
 *
 * @author chuhy
 * @date
 */
@Data
@EqualsAndHashCode(callSuper = false)
public class CropStaffEnrollSearchParam extends PageParam {
    private static final long serialVersionUID = 4385499347039147333L;

    @ApiModelProperty("培训ID")
    private Long tid;

    @ApiModelProperty("单位ID")
    private Long cid;

    @ApiModelProperty("是否考试未完成")
    private Integer isIncompleteTest;

    @ApiModelProperty("是否培训未完成")
    private Integer isIncompleteTrain;

    @ApiModelProperty("状态(0-退回；1-待培训；2-培训中；3-已取证；4-培训结束)")
    private Byte status;

    @ApiModelProperty("报名来源(1个人报名、2单位报名、后台赠送（3单位/4个人）、后台线下（5单位/6个人）)")
    private Byte enrollSource;

    @ApiModelProperty(hidden = true,value = "用于标记搜索框的内容是否为身份证号")
    private Byte isIdCard;

    @ApiModelProperty(value = "是否只查单位报名人员(0-否;1-是)")
    private Byte isOnlyCrop;

}
