package cn.smarthse.radiationTraining.modules.training.param.enroll;

import cn.smarthse.radiationTraining.core.framework.model.UserEditParam;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.experimental.Accessors;

import java.io.Serializable;

/**
 * @ClassName UnitEnrollParam
 * @Description 单位选择培训参数
 * @Author ChenLiang
 * @ModifyDate 2022/3/23 13:10
 */
@Data
@Accessors(chain = true)
public class CropSelectTraninglParam extends UserEditParam implements Serializable {

    @ApiModelProperty("培训主表id")
    private Long tid;

    @ApiModelProperty(value = "企业报名id",hidden = true)
    private Long enrollId;

    @ApiModelProperty(value = "企业id")
    private Long cid;

    @ApiModelProperty(value = "报名来源（1个人 3单位）")
    private Integer source;

    @ApiModelProperty(value = "企业名称",hidden = true)
    private String companyName;

    @ApiModelProperty(value = "企业名称",hidden = true)
    private Integer userType;

    @ApiModelProperty(value = "社会信用代码",hidden = true)
    private String creditCode;

}
