package cn.smarthse.radiationTraining.modules.training.param.course;

import cn.smarthse.radiationTraining.core.framework.model.PageParam;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;

/**
 * 用户考试列表，以课程为主体单位
 *
 * @author wuxq
 * @date
 */
@EqualsAndHashCode(callSuper = false)
@Data
public class TuCoursePageParam extends PageParam {

    @ApiModelProperty(value = "用户id", hidden = true)
    private Long uid;

    @ApiModelProperty(value = "培训id", required = true)
    private Long tid;

    @ApiModelProperty(value = "培训报名详情", required = true)
    private Long tuEnrollDetailId;

    @ApiModelProperty(value = "培训模式(0-专业; 1-精准;2-服务机构)", required = true)
    private Integer trainMode;

    @ApiModelProperty(value = "在线考试方式(0-分别考试；1-统一考试)", required = true)
    private Integer testMode;

    @ApiModelProperty(value = "考试状态：0-待考试；1-未通过；2-已通过")
    private Integer status;

}
