package cn.smarthse.radiationTraining.modules.training.param.course;

import cn.smarthse.radiationTraining.core.framework.model.PageParam;
import cn.smarthse.radiationTraining.core.framework.utils.StringUtils;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;

import java.util.Collections;
import java.util.List;

/**
 * 课程组查询参数对象
 *
 * @author
 * @date
 */
@EqualsAndHashCode(callSuper = false)
@Data
public class GroupPageParam extends PageParam {

    @ApiModelProperty("课程组状态（1：启用、2：禁用）")
    private Integer status;

    @ApiModelProperty("是否包含课程(0不包含，1包含)")
    private byte ifIncludeCourse = 0;
    @ApiModelProperty("课程状态(0-草稿，1-启用，2-禁用)")
    private Integer courseItemState;
    @ApiModelProperty("区域id")
    private Long areaId;
    @ApiModelProperty("观看条件（0通用，1专用）枚举：CourseItemPermissionEnum")
    private Integer permissionType;

    @ApiModelProperty("人员类型集合")
    private List<String> personCodeList;
    @ApiModelProperty("危害因素集合")
    private List<String> riskCodeList;
    @ApiModelProperty("行业因素集合")
    private List<String> industryCodeList;

    @ApiModelProperty("只显示自己的(null 表示全部)")
    private Long createBy;


    public Integer getAreaLevel() {
        return this.areaId == null ? null : StringUtils.getAreaLevel(areaId);
    }
}
