package cn.smarthse.radiationTraining.modules.training.param.course;

import cn.smarthse.radiationTraining.core.framework.model.PageParam;
import cn.smarthse.radiationTraining.core.framework.utils.StringUtils;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;

import java.util.List;

/**
 * 课程组查询参数对象
 *
 * @author
 * @date
 */
@EqualsAndHashCode(callSuper = false)
@Data
public class CoursePageParam extends PageParam {


    @ApiModelProperty("危害因数大类")
    private String riskType;
    @ApiModelProperty("人员类型")
    private String personType;
    @ApiModelProperty("行业类型")
    private String indusrtyType;

    @ApiModelProperty("课程状态状态（0-草稿，1-启用，2-禁用）")
    private Integer status;

    @ApiModelProperty("人员类型集合")
    private List<String> personCodeList;
    @ApiModelProperty("危害因素集合")
    private List<String> riskCodeList;
    @ApiModelProperty("行业因素集合")
    private List<String> industryCodeList;



    @ApiModelProperty("观看条件（0共有，1专又）枚举：CourseItemPermissionEnum")
    private Integer permissionType;

    @ApiModelProperty("观看条件（0通用，1专用）枚举：CourseItemPermissionEnum")
    private Integer courseType;

    @ApiModelProperty("区域id")
    private Long areaId;

    @ApiModelProperty("请求来源(1 课程管理)")
    private Integer reqSource;

    @ApiModelProperty(value = "区域等级",hidden = true)
    private Integer areaLevel;




    public Integer getAreaLevel() {
       return this.areaId == null ? null : StringUtils.getAreaLevel(areaId);
    }



    public List<String> getPersonCodeList() {
        return this.personType != null ? null : personCodeList;
    }
}
