package cn.smarthse.radiationTraining.modules.training.param.course;

import cn.smarthse.radiationTraining.core.framework.model.UserEditParam;
import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableId;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.experimental.Accessors;

import java.util.Date;

/**
 * @ClassName CourseGroupEditParam
 * @Description 课程编辑参数
 * @Author ChenLiang
 * @ModifyDate 2022/3/18 15:15
 */
@Data
@Accessors(chain = true)
public class CourseGroupEditParam extends UserEditParam {

    /**
     * 编号
     */
    @ApiModelProperty("编号")
    private Long id;
    /**
     * 课程组名
     */
    @ApiModelProperty("课程组名")
    private String name;


    /**
     * 状态（1-启用，2-关闭）
     */
    @ApiModelProperty("状态（1-启用，2-关闭）")
    private Integer status;

    @ApiModelProperty("类型（0普通 1默认 2老极简 3新极简）")
    private Integer type;

}
