package cn.smarthse.radiationTraining.modules.training.enums;

import lombok.AllArgsConstructor;
import lombok.Getter;

/**
 * 培训状态 枚举
 *
 * @author wuxq
 * @date 2022/3/14
 */
@AllArgsConstructor
@Getter
public enum TrainingTypeEnum {

    FIRST(0, "初次培训","初次培训"),

    SECONDE(1, "继续教育","继续教育");

    private Integer value;

    private String value2;

    private String name;


    public static Integer getValueByName(String v) {
        if (v == null) {
            return null;
        }

        for (TrainingTypeEnum e : values()) {
            if (e.getName().equals(v)) {
                return e.getValue();
            }
        }
        return null;
    }
    public static Integer getValueByValue2(String v) {
        if (v == null) {
            return null;
        }

        for (TrainingTypeEnum e : values()) {
            if (e.getValue2().equals(v)) {
                return e.getValue();
            }
        }
        return null;
    }

}
