package cn.smarthse.radiationTraining.modules.training.enums;


/**
 *
 * 培训对象(0-用人单位；11-技术服务机构；12-职业健康体检机构；13-技术服务、职业健康体检机构)
 *
 * @author chuhy
 * @date 2022/12/19
 */
public enum TrainTargetEnum {

    /**
     *  0-用人单位
     */
    UNIT(0, "用人单位"),

    /**
     * 11-技术服务机构
     */
    TECH_ORIG(11, "技术服务机构"),

    /**
     * 12-职业健康体检机构
     */
    EXAMINATION_ORIG(12, "职业健康体检机构"),


    /**
     * 13-技术服务 与 职业健康体检机构
     */
    TECH_AND_EXAMINATION_ORIG(13, "技术服务 与 职业健康体检机构"),


    ;

    private Integer value;

    private String name;

    TrainTargetEnum(Integer value, String name) {
        this.value = value;
        this.name = name;
    }

    public Integer getValue() {
        return value;
    }

    public void setValue(Integer value) {
        this.value = value;
    }

    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }
}
