package cn.smarthse.radiationTraining.modules.training.entity.training;

import com.baomidou.mybatisplus.annotation.*;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.util.Date;

@Data
@TableName("training_course_person_type")
public class TrainingCoursePersonType implements Serializable {

    private static final Long serialVersionUID = 844349057060662745L;

    @TableId(value = "id", type = IdType.ASSIGN_ID)
    private Long id;

    @ApiModelProperty("培训ID")
    private Long tid;

    @ApiModelProperty("课程ID")
    private Long courseId;

    @ApiModelProperty("培训课程ID")
    private Long trainingCourseId;

    @ApiModelProperty("人员类型名称")
    private String name;

    @ApiModelProperty("人员类型code(见TrainingPersonTypeEnum枚举)")
    private String code;

    @ApiModelProperty("课程学习状态（1-需要学习；2-无需学习）")
    private Integer studyStatus;


    @ApiModelProperty("创建时间")
    private Date createTime;

    @ApiModelProperty("更新时间")
    private Date updateTime;

    @ApiModelProperty("创建人")
    private Long createBy;

    @ApiModelProperty("更新人")
    private Long updateBy;

    @ApiModelProperty("是否有效(0-无效；1-有效)")
    private Byte isValid;

    @ApiModelProperty("（前端冗余字段，用于他们判断使用，与业务无关）课程必修类型")
    private Integer mustLearnType;

}
