package cn.smarthse.radiationTraining.modules.training.entity.training;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableLogic;
import com.baomidou.mybatisplus.annotation.TableName;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.io.Serializable;
import java.util.Date;

/**
 * 培训-行业关系表
 *
 * @Author:chuhy
 * @create:2022/8/15
 */
@Data
@TableName("training_change_record")
@NoArgsConstructor
public class TrainingChangeRecord implements Serializable {

    private static final Long serialVersionUID = 5939003209203754362L;

    @TableId(value = "id", type = IdType.ASSIGN_ID)
    private Long id;

    /**
     * 培训id
     */
    private Long tid;

    /**
     * 变更内容
     */
    private String changeInfo;

    /**
     * 变更人
     */
    private String changePerson;

    /**
     * 变更时间
     */
    private Date changeTime;

    /**
     * 创建时间
     */
    private Date createTime;

    /**
     * 更新时间
     */
    private Date updateTime;

    /**
     * 创建人
     */
    private Long createBy;

    /**
     * 更新人
     */
    private Long updateBy;

    /**
     * 是否有效(0-无效；1-有效)
     */
    @TableLogic
    private Boolean isValid;

    public TrainingChangeRecord(Long tid, String changePerson, Date changeTime) {
        this.tid = tid;
        this.changePerson = changePerson;
        this.changeTime = changeTime;
    }
}
