package cn.smarthse.radiationTraining.modules.training.entity.course;

import java.io.Serializable;
import java.util.Date;
import javax.persistence.*;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableId;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.experimental.Accessors;


/**
 * 用户-培训学习课程
 *
 * @author <wuxq>
 * @since 2022-03-23 02:14
 */
@Data
@Accessors(chain = true)
@Table(name = "tu_course")
public class TuCourse implements Serializable{

	private static final long serialVersionUID = 1L;
	/**
	 * ID
	 */
	@TableId(value = "id", type = IdType.ASSIGN_ID)
	private Long id;
	/**
	 * 用户id
	 */
	private Long userId;
	/**
	 * 培训主表id
	 */
	private Long tid;
	/**
	 * 企业报名id
	 */
	private Long enrollId;
	/**
	 * 用户报名id
	 */
	private Long enrollDetailId;
	/**
	 * 培训课程training_course.id
	 */
	private Long trainingCourseId;
	/**
	 * 培训课程course_item_id
	 */
	private Long courseItemId;
	/**
	 * 课程名称
	 */
	private String courseName;
	/**
	 * 讲师名称
	 */
	private String lecturer;
	/**
	 * 简介
	 */
	private String description;
	/**
	 * 学习时长(秒)；
	 */
	private Long stuDurationSec;
	/**
	 * 视频地址
	 */
	private String videoUrl;
	/**
	 * 视频id(sys_file表id)
	 */
	private Long videoId;
	/**
	 * 封面地址
	 */
	private String coverUrl;
	/**
	 * 封面id(sys_file表id)
	 */
	private Long coverId;
	/**
	 * 视频时长
	 */
	private Long videoDurationSec;
	/**
	 * 课程类型
	 */
	private Integer courseType;
	/**
	 * 试卷接口id
	 */
	private Long paperStructureId;
	/**
	 * 课程学习状态：0-未学习；1-学习中；2-已完成；
	 */
	private Integer status;
	/**
	 * 考试是否通过（必考有此字段）：0-待考试；1-未通过；2-已通过
	 */
	private Integer isPassed;
	/**
	 * 是否考试：0 否 1 是
	 */
	private Integer isTest;
	/**
	 * 最新分数
	 */
	private Integer score;
	/**
	 * 重考次数限制(0-不限次数)
	 */
	private Integer retestLimit;

	/**
	 * 培训类型(0-专业；1-精准；)
	 */
	private Integer trainMode;
	/**
	 * 学时
	 */
	private Double classHour;
	/**
	 * 创建时间
	 */
	private Date createTime;

	/**
	 *组卷方式（默认1：自动；2：手动）
	 */
	private Integer way;
	/**
	 *单选题数
	 */
	private Integer singleNum;
	/**
	 *多选题数
	 */
	private Integer multipleNum;
	/**
	 *填空题数
	 */
	private Integer completionNum;
	/**
	 * 判断题数
	 */
	@ApiModelProperty(value = "判断题数")
	private Integer judgeNum;
	/**
	 *每个单选题分数
	 */
	private Integer singleScore;
	/**
	 *每个多选题分数
	 */
	private Integer multipleScore;
	/**
	 *每个填空题分数
	 */
	private Integer completionScore;
	/**
	 * 每个判断题分数
	 */
	@ApiModelProperty(value = "每个判断题分数")
	private Integer judgeScore;
	/**
	 * 总分
	 */
	private Integer totalScore;
	/**
	 * 行业code，英文逗号隔开
	 */
	private String industry;
	/**
	 * 危害因素code，英文逗号隔开
	 */
	private String riskFactor;
	/**
	 * 人员类型code，英文逗号隔开
	 */
	private String personType;

	/**
	 * 更新时间
	 */
	private Date updateTime;
	/**
	 * 创建人
	 */
	private Long createBy;
	/**
	 * 更新人
	 */
	private Long updateBy;
	/**
	 * 是否有效(0-无效；1-有效)
	 */
	private Boolean isValid;


}
