package cn.smarthse.radiationTraining.modules.training.entity.course;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableId;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.experimental.Accessors;

import javax.persistence.Table;
import java.io.Serializable;
import java.util.Date;


@Data
@Table(name = "course_group")
@Accessors(chain = true)
public class CourseGroup implements Serializable {
    /**
     * 编号
     */
    @ApiModelProperty("编号")
    @TableId(value = "id", type = IdType.ASSIGN_ID)
    private Long id;
    /**
     * 课程组名
     */
    @ApiModelProperty("课程组名")
    private String name;
    /**
     * 编辑人
     */
    @ApiModelProperty("编辑人")
    private Long editor;

    @ApiModelProperty("课程数量")
    private Long courseNumber;

    /**
     * 状态（0-关闭，1-启用）
     */
    @ApiModelProperty("状态（1：启用、2：禁用）")
    private Integer status;

    @ApiModelProperty("类型（0普通 1默认 2老极简 3新极简）")
    private Integer type;

    /**
     * 创建人
     */
    private Long createBy;
    /**
     * 更新人
     */
    private Long updateBy;
    /**
     * 创建时间
     */
    private Date createDate;
    /**
     * 更新时间
     */
    private Date updateDate;
    /**
     * 是否有效（0-无效，1-有效）
     */
    private Integer isValid;

}
