package cn.smarthse.radiationTraining.modules.training.converter;

import cn.smarthse.radiationTraining.modules.training.entity.enroll.TuEnrollDetail;
import cn.smarthse.radiationTraining.modules.training.param.enroll.SaveStaffDraftInfoParam;
import org.mapstruct.Mapper;
import org.mapstruct.Mapping;
import org.mapstruct.factory.Mappers;

import java.util.Date;

/**
 * @ClassName TuEnrollConverter
 * @Description TuEnroll转换
 * @Author ChenLiang
 * @ModifyDate 2022/3/23 15:17
 */
@Mapper(componentModel = "spring",imports = {Date.class})
public interface TuEnrollDetailConverter {
    TuEnrollDetailConverter INSTANCE = Mappers.getMapper(TuEnrollDetailConverter.class);

    /**
     * 报名参数转实体
     * @param cropSignUpParam
     * @return
     */
    @Mapping(target = "enrollTime",expression = "java(new Date())")
    @Mapping(target = "createTime",expression = "java(new Date())")
    @Mapping(target = "updateTime",expression = "java(new Date())")
    @Mapping(target = "studiedProgress",expression = "java(0)")
    @Mapping(target = "testedProgress",expression = "java(0)")
    @Mapping(target = "createBy",expression = "java(cropSignUpParam.getLoginUserId())")
    @Mapping(target = "updateBy",expression = "java(cropSignUpParam.getLoginUserId())")
    TuEnrollDetail param2Entity(SaveStaffDraftInfoParam cropSignUpParam);
}
