package cn.smarthse.radiationTraining.modules.training.converter;


import cn.smarthse.radiationTraining.modules.training.vo.training.TrainingBaseInfoVo;
import cn.smarthse.radiationTraining.modules.training.vo.training.TrainingDetailVo;
import cn.smarthse.radiationTraining.modules.training.vo.training.TrainingListVo;
import cn.smarthse.radiationTraining.modules.training.vo.training.UserMyTrainListVo;
import jdk.nashorn.internal.ir.annotations.Ignore;
import org.mapstruct.Mapper;
import org.mapstruct.Mapping;
import org.mapstruct.MappingTarget;
import org.mapstruct.Mappings;
import org.mapstruct.factory.Mappers;

@Mapper(componentModel = "spring")
public interface TrainingListVoConverter {
    TrainingListVoConverter INSTANCE = Mappers.getMapper(TrainingListVoConverter.class);

    @Mappings({
            @Mapping(source = "vo2.isEnroll", target = "isEnroll")
    })
    TrainingListVo entityCopyToEntity (TrainingListVo vo2);


    void trainDetailToListVo(TrainingDetailVo resource, @MappingTarget TrainingListVo target);

    /**
     * 培训基础信息 转 用户培训基础信息
     * @return
     */
    @Mapping(source = "id" ,target = "tid")
    void baseToUserBase(TrainingDetailVo trainInfo, @MappingTarget UserMyTrainListVo target);

    /**
     * 培训基础信息 转 wx培训基础信息
     * @return
     */
    @Mappings(value = {
            @Mapping(source = "trainWorkTypeNameList" ,target = "workType"),
            @Mapping(target = "retestLimit", ignore = true)
    })
    void baseToWxBase(TrainingDetailVo trainInfo, @MappingTarget TrainingBaseInfoVo target);
}
