package cn.smarthse.radiationTraining.modules.training.converter;

import cn.smarthse.radiationTraining.modules.training.entity.training.Training;
import cn.smarthse.radiationTraining.modules.training.param.training.TrainingAddParam;
import cn.smarthse.radiationTraining.modules.training.param.training.TrainingUpdateParam;
import cn.smarthse.radiationTraining.modules.training.vo.training.TrainChangeRecordVo;
import cn.smarthse.radiationTraining.modules.training.vo.training.TrainHomeCropExportVo;
import cn.smarthse.radiationTraining.modules.training.vo.training.TrainHomeCropVo;
import cn.smarthse.radiationTraining.modules.training.vo.training.TrainingDetailVo;
import org.mapstruct.Mapper;
import org.mapstruct.Mapping;
import org.mapstruct.factory.Mappers;

import java.util.List;

@Mapper(componentModel = "spring")
public interface TrainingConverter {
    TrainingConverter INSTANCE = Mappers.getMapper(TrainingConverter.class);

    /**
     * 实体 转 vo
     * @return
     */
    TrainingDetailVo trainingToDetailVo (Training training);

    /**
     * vo 转 实体
     * @return
     */
    Training voToEntity(TrainingDetailVo vo);

    /**
     * 编辑Param 转 实体
     * @return
     */
    @Mapping(source = "trainingId" ,target = "id")
    Training updateParamToTraining(TrainingUpdateParam updateParam);

    /**
     * 新增Param 转 实体
     * @return
     */
    @Mapping(source = "trainingId" ,target = "id")
    Training addParamToTraining(TrainingAddParam addParam);

    /**
     * 新增Param 转 vo
     * @return
     */
    @Mapping(source = "trainingId" ,target = "id")
    TrainingDetailVo addParamToDetailVo(TrainingAddParam addParam);

    /**
     * 更新param 转 修改记录vo
     */
    TrainChangeRecordVo addParamToChangeRecordVo(TrainingUpdateParam updateParam);

    /**
     * 更新param 转 新增Param
     */
    TrainingAddParam updateParamToAddParam(TrainingUpdateParam updateParam);

    /**
     * 单位档案列表vo 转 导出vo
     */
    List<TrainHomeCropExportVo> homeCropVoToExportVo(List<TrainHomeCropVo> vo);

}
