package cn.smarthse.radiationTraining.modules.training.converter;


import cn.smarthse.radiationTraining.modules.training.entity.course.CourseItem;
import cn.smarthse.radiationTraining.modules.training.param.course.CourseItemAddParam;
import cn.smarthse.radiationTraining.modules.training.param.course.CourseItemEditFullInfoParam;
import cn.smarthse.radiationTraining.modules.training.vo.course.CourseItemVo;
import cn.smarthse.radiationTraining.modules.training.vo.training.TrainingCourseItemVo;
import org.mapstruct.Mapper;
import org.mapstruct.Mapping;
import org.mapstruct.factory.Mappers;

import java.util.List;

@Mapper(componentModel = "spring")
public interface CourseItemConverter {
    CourseItemConverter INSTANCE = Mappers.getMapper(CourseItemConverter.class);

    /**
     * 实体 转 vo
     * @param courseItem
     * @return
     */
    CourseItemVo courseItem2Vo(CourseItem courseItem);

    /**
     * 实体集合 转 vo集合
     * @param courseItemList
     * @return
     */
    List<CourseItemVo> courseItemList2VoList(List<CourseItem> courseItemList);

//    /**
//     * dto 转 vo
//     * @param courseItemDto
//     * @return
//     */
//    @Mapping(target = "workTypeNames", expression = "java(cn.smarthse.radiationTraining.modules.training.converter.ConverterUtils.str2List(courseItemDto.getWorkTypeNames(),\",\"))")
//    CourseItemVo courseItemDto2Vo(CourseItemDto courseItemDto);

//    /**
//     * dto集合转vo集合
//     */
//    List<CourseItemVo> courseItemDtoListVo(List<CourseItemDto> courseItemDtoList);

//    LayuiGridData<CourseItemVo> layuiGridDataDtoToVo(LayuiGridData<CourseItemDto> layuiGridData);

    /**
     * 参数转实体
     * @param param
     * @return
     */
    @Mapping(source = "param.loginUserId", target = "editor")
    @Mapping(source = "param.loginUserId", target = "createBy")
    @Mapping(source = "param.loginUserId", target = "updateBy")
    @Mapping(target = "isValid",expression = "java(1l)")
    CourseItem param2CourseItem(CourseItemAddParam param);

    @Mapping(source = "param.loginUserId", target = "editor")
    @Mapping(source = "param.loginUserId", target = "createBy")
    @Mapping(source = "param.loginUserId", target = "updateBy")
    @Mapping(target = "isValid",expression = "java(1l)")
    CourseItem editFullInfoParam2CourseItem(CourseItemEditFullInfoParam param);

    TrainingCourseItemVo vo2TrainingCourItem(CourseItemVo courseItemVo);
}
