/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.radiationTraining.modules.wqxx.service.impl;

import cn.hutool.core.date.DateUtil;
import cn.smarthse.framework.mybatisPlus.service.impl.ServiceImpl;
import cn.smarthse.radiationTraining.core.framework.model.LayuiGridData;
import cn.smarthse.radiationTraining.core.framework.model.LayuiGridParam;
import cn.smarthse.radiationTraining.core.framework.model.PageParam;
import cn.smarthse.radiationTraining.core.framework.utils.DateUtils;
import cn.smarthse.radiationTraining.modules.sys.provider.sys.ISysCompanyStaffProviderService;
import cn.smarthse.radiationTraining.modules.sys.vo.user.info.CompanyListVo;
import cn.smarthse.radiationTraining.modules.wqxx.dao.SUserIntegralLogMapper;
import cn.smarthse.radiationTraining.modules.wqxx.entity.SUserExam;
import cn.smarthse.radiationTraining.modules.wqxx.entity.SUserIntegralLog;
import cn.smarthse.radiationTraining.modules.wqxx.enums.UserExamTypeEnum;
import cn.smarthse.radiationTraining.modules.wqxx.enums.UserIntegralTypeEnum;
import cn.smarthse.radiationTraining.modules.wqxx.model.vo.integraLog.StaffStudyArchivesVo;
import cn.smarthse.radiationTraining.modules.wqxx.model.vo.integraLog.StaffStudyIntegralVo;
import cn.smarthse.radiationTraining.modules.wqxx.model.vo.integraLog.StaffTodayIntegralVo;
import cn.smarthse.radiationTraining.modules.wqxx.model.vo.integraLog.UnitStudyArchivesVo;
import cn.smarthse.radiationTraining.modules.wqxx.param.answerExercise.SubmitAnswerQuestionParam;
import cn.smarthse.radiationTraining.modules.wqxx.param.integraLog.StudyArchivesSearchParam;
import cn.smarthse.radiationTraining.modules.wqxx.service.ISUserIntegralLogService;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.github.pagehelper.Page;
import com.github.pagehelper.PageHelper;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.dubbo.config.annotation.DubboReference;
import org.springframework.stereotype.Service;

@Service
public class SUserIntegralLogServiceImpl
extends ServiceImpl<SUserIntegralLogMapper, SUserIntegralLog>
implements ISUserIntegralLogService {
    @DubboReference
    ISysCompanyStaffProviderService sysCompanyStaffProviderService;

    @Override
    public LayuiGridData<StaffStudyArchivesVo> getStaffStudyArchivesPageData(StudyArchivesSearchParam param) {
        PageHelper.startPage((int)param.getPage(), (int)param.getLimit());
        List<StaffStudyArchivesVo> list = this.getStaffStudyArchivesListData(param);
        return new LayuiGridData((Page)list, (LayuiGridParam)param);
    }

    @Override
    public List<StaffStudyArchivesVo> getStaffStudyArchivesListData(StudyArchivesSearchParam param) {
        List<StaffStudyArchivesVo> provinceRankList;
        List<StaffStudyArchivesVo> list = ((SUserIntegralLogMapper)this.baseMapper).getStaffStudyArchives(param);
        if (CollectionUtils.isNotEmpty(list) && CollectionUtils.isNotEmpty(provinceRankList = ((SUserIntegralLogMapper)this.baseMapper).getStaffProvinceRanking((PageParam)param))) {
            list.forEach(item -> {
                StaffStudyArchivesVo provinceRank = provinceRankList.stream().filter(f -> f.getUserId() != null && item.getUserId() != null && f.getCid() != null && item.getCid() != null && f.getUserId().equals(item.getUserId()) && f.getCid().equals(item.getCid())).findFirst().orElse(null);
                item.setProvinceRanking(provinceRank == null ? null : provinceRank.getProvinceRanking());
            });
        }
        return list;
    }

    @Override
    public StaffStudyIntegralVo getStaffStudyIntegralVo(StudyArchivesSearchParam param) {
        StaffStudyIntegralVo integralVo = ((SUserIntegralLogMapper)this.baseMapper).getStaffStudyIntegralVo(param.getUserId(), param.getCid());
        if (integralVo == null) {
            return ((SUserIntegralLogMapper)this.baseMapper).getStaffStudyIntegralVoWithoutRank(param.getUserId());
        }
        StaffStudyArchivesVo provinceRank = this.getStaffProvinceRank(param);
        if (integralVo != null && provinceRank != null) {
            integralVo.setIntegralTotal(provinceRank.getIntegralTotal());
            integralVo.setProvinceRanking(provinceRank.getIntegralTotal() == 0 ? null : provinceRank.getProvinceRanking());
        }
        StaffStudyArchivesVo provinceChallengeRank = this.getStaffChallengeProvinceRank(param);
        if (integralVo != null && provinceChallengeRank != null) {
            integralVo.setChallengeRanking(provinceChallengeRank.getChallengeIntegralTotal() == 0 ? null : provinceChallengeRank.getChallengeRanking());
        }
        StaffStudyArchivesVo unitRank = this.getStaffUnitRank(param);
        if (integralVo != null && unitRank != null) {
            integralVo.setUnitRanking(unitRank.getIntegralTotal() == 0 ? null : unitRank.getUnitRanking());
        }
        return integralVo;
    }

    public StaffStudyArchivesVo getStaffProvinceRank(StudyArchivesSearchParam param) {
        if (param.getUserId() == null) {
            return null;
        }
        List<StaffStudyArchivesVo> list = ((SUserIntegralLogMapper)this.baseMapper).getStaffProvinceRanking((PageParam)param);
        if (CollectionUtils.isNotEmpty(list)) {
            return list.get(0);
        }
        return null;
    }

    public StaffStudyArchivesVo getStaffChallengeProvinceRank(StudyArchivesSearchParam param) {
        if (param.getUserId() == null) {
            return null;
        }
        List<StaffStudyArchivesVo> list = ((SUserIntegralLogMapper)this.baseMapper).getStaffChallengeProvinceRanking(param);
        if (CollectionUtils.isNotEmpty(list)) {
            return list.get(0);
        }
        return null;
    }

    public StaffStudyArchivesVo getStaffUnitRank(StudyArchivesSearchParam param) {
        if (param.getUserId() == null) {
            return null;
        }
        List<StaffStudyArchivesVo> list = ((SUserIntegralLogMapper)this.baseMapper).getStaffStudyArchives(param);
        if (CollectionUtils.isNotEmpty(list)) {
            return list.get(0);
        }
        return null;
    }

    @Override
    public LayuiGridData<StaffStudyArchivesVo> getStaffStudyDetailsPageData(StudyArchivesSearchParam param) {
        CompanyListVo newest;
        boolean isSameBindComp = true;
        if (!(param.getCid() == null || (newest = this.sysCompanyStaffProviderService.getNewestByUidAndSource(param.getUserId(), null)) != null && Objects.equals(newest.getId(), param.getCid()))) {
            isSameBindComp = false;
        }
        PageHelper.startPage((int)param.getPage(), (int)param.getLimit());
        List<Object> list = new ArrayList();
        list = isSameBindComp ? this.getStaffStudyDetailsListData(param) : ((SUserIntegralLogMapper)this.baseMapper).getStaffStudyDetailsWithoutRankListData(param);
        return new LayuiGridData((Page)list, (LayuiGridParam)param);
    }

    @Override
    public List<StaffStudyArchivesVo> getStaffStudyDetailsListData(StudyArchivesSearchParam param) {
        List<StaffStudyArchivesVo> provinceRankList;
        List<StaffStudyArchivesVo> list = ((SUserIntegralLogMapper)this.baseMapper).getStaffStudyDetailsPageData(param);
        if (CollectionUtils.isNotEmpty(list) && CollectionUtils.isNotEmpty(provinceRankList = ((SUserIntegralLogMapper)this.baseMapper).getStaffStudyDetailsProvinceRank(param))) {
            list.forEach(item -> {
                StaffStudyArchivesVo provinceRank = provinceRankList.stream().filter(f -> f.getUserId().equals(item.getUserId()) && f.getYears().equals(item.getYears())).findFirst().orElse(null);
                item.setProvinceRanking(provinceRank == null ? null : provinceRank.getProvinceRanking());
            });
        }
        return list;
    }

    @Override
    public LayuiGridData<UnitStudyArchivesVo> getUnitStudyArchivesPageData(StudyArchivesSearchParam param) {
        PageHelper.startPage((int)param.getPage(), (int)param.getLimit());
        List<UnitStudyArchivesVo> list = ((SUserIntegralLogMapper)this.baseMapper).getUnitStudyArchives(param);
        return new LayuiGridData((Page)list, (LayuiGridParam)param);
    }

    @Override
    public boolean judgeObtainIntegralForStudy(Long userId, Integer type) {
        List<SUserIntegralLog> integralLogList;
        Integer integralType = UserIntegralTypeEnum.ARTICLE_LEARN.getValue();
        if (type == 2) {
            integralType = UserIntegralTypeEnum.VIDEO_LEARN.getValue();
        }
        return CollectionUtils.isNotEmpty(integralLogList = ((SUserIntegralLogMapper)this.baseMapper).selectAllForStudy(userId, integralType, DateUtils.getMondayDateInThisWeek(), DateUtils.getSundayDateInThisWeek()));
    }

    @Override
    public LayuiGridData<UnitStudyArchivesVo> getUnitStudyDetailsPageData(StudyArchivesSearchParam param) {
        PageHelper.startPage((int)param.getPage(), (int)param.getLimit());
        List<UnitStudyArchivesVo> list = ((SUserIntegralLogMapper)this.baseMapper).getUnitStudyDetailsPageData(param);
        return new LayuiGridData((Page)list, (LayuiGridParam)param);
    }

    @Override
    public void addIntegralByStudy(SUserIntegralLog entity) {
        if (null != entity) {
            int integralSum;
            List integralLogList;
            LambdaQueryWrapper wrapper;
            if (entity.getType() == UserIntegralTypeEnum.ARTICLE_LEARN.getValue()) {
                wrapper = new LambdaQueryWrapper();
                ((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)wrapper.eq(SUserIntegralLog::getUserId, (Object)entity.getUserId())).eq(SUserIntegralLog::getType, (Object)UserIntegralTypeEnum.ARTICLE_LEARN.getValue())).eq(SUserIntegralLog::getObtainDate, (Object)LocalDate.now())).eq(SUserIntegralLog::getIsValid, (Object)1);
                integralLogList = this.list((Wrapper)wrapper);
                integralSum = integralLogList.stream().mapToInt(SUserIntegralLog::getIntegral).sum();
                if (integralSum < 1) {
                    this.save(entity);
                }
            }
            if (entity.getType() == UserIntegralTypeEnum.VIDEO_LEARN.getValue()) {
                wrapper = new LambdaQueryWrapper();
                ((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)wrapper.eq(SUserIntegralLog::getUserId, (Object)entity.getUserId())).eq(SUserIntegralLog::getType, (Object)UserIntegralTypeEnum.VIDEO_LEARN.getValue())).eq(SUserIntegralLog::getObtainDate, (Object)LocalDate.now())).eq(SUserIntegralLog::getIsValid, (Object)1);
                integralLogList = this.list((Wrapper)wrapper);
                integralSum = integralLogList.stream().mapToInt(SUserIntegralLog::getIntegral).sum();
                if (integralSum < 5) {
                    this.save(entity);
                }
            }
        }
    }

    @Override
    public Integer addIntegralByExam(SUserExam userExam, SubmitAnswerQuestionParam param) {
        List<SUserIntegralLog> userIntegralList;
        Integer rst = 0;
        SUserIntegralLog entity = new SUserIntegralLog();
        entity.setName(param.getUserName());
        entity.setUserName(param.getUserLoginName());
        entity.setPhone(param.getUserPhone());
        entity.setCid(param.getCid());
        entity.setUserId(userExam.getUserId());
        entity.setBusinessId(userExam.getId());
        entity.setObtainDate(param.getOptDate());
        entity.setCreateDate(param.getOptDate());
        if (userExam.getType().intValue() == UserExamTypeEnum.WEEKLY_EXAM.getValue()) {
            userIntegralList = ((SUserIntegralLogMapper)this.baseMapper).searchAllByUserIdAndType(userExam.getUserId(), userExam.getCid(), userExam.getType(), userExam.getId(), null, null);
            if (CollectionUtils.isNotEmpty(userIntegralList)) {
                return rst;
            }
            entity.setType(UserIntegralTypeEnum.WEEKLY_EXAM.getValue());
            entity.setIntegral(userExam.getTotalScore());
            this.save(entity);
            rst = userExam.getTotalScore();
        }
        if (userExam.getType().intValue() == UserExamTypeEnum.SPECIAL_EXAM.getValue()) {
            userIntegralList = ((SUserIntegralLogMapper)this.baseMapper).searchAllByUserIdAndType(userExam.getUserId(), userExam.getCid(), userExam.getType(), userExam.getId(), null, null);
            if (CollectionUtils.isNotEmpty(userIntegralList)) {
                return rst;
            }
            entity.setType(UserIntegralTypeEnum.SPECIAL_EXAM.getValue());
            entity.setIntegral(userExam.getTotalScore());
            this.save(entity);
            rst = userExam.getTotalScore();
        }
        if (userExam.getType().intValue() == UserExamTypeEnum.CHALLENGE_EXAM.getValue()) {
            entity.setType(UserIntegralTypeEnum.CHALLENGE_EXAM.getValue());
            userIntegralList = ((SUserIntegralLogMapper)this.baseMapper).searchAllByUserIdAndType(userExam.getUserId(), userExam.getCid(), userExam.getType(), null, new Date(), null);
            int obtainedScore = 0;
            for (SUserIntegralLog userInt : userIntegralList) {
                obtainedScore += userInt.getIntegral().intValue();
            }
            int scoreSum = obtainedScore + userExam.getTotalScore();
            if (obtainedScore < 5) {
                if (scoreSum > 5) {
                    entity.setIntegral(Integer.valueOf(5 - obtainedScore));
                    rst = 5 - obtainedScore;
                } else {
                    entity.setIntegral(userExam.getTotalScore());
                    rst = userExam.getTotalScore();
                }
                this.save(entity);
            }
        }
        return rst;
    }

    @Override
    public List<StaffStudyArchivesVo> getStaffIntegralRankList(StudyArchivesSearchParam param) {
        if (param.getCid() == null) {
            return Collections.emptyList();
        }
        List<Object> resultList = ((SUserIntegralLogMapper)this.baseMapper).getStaffStudyArchives(param);
        if (CollectionUtils.isNotEmpty(resultList)) {
            resultList = resultList.stream().limit(20L).collect(Collectors.toList());
        }
        return resultList;
    }

    @Override
    public StaffStudyIntegralVo getStaffIntegral(StudyArchivesSearchParam param) {
        StaffStudyIntegralVo studyIntegralVo = this.getStaffStudyIntegralVo(param);
        param.setYear(Integer.valueOf(DateUtil.thisYear()));
        Integer yearIntegralTotal = ((SUserIntegralLogMapper)this.baseMapper).getStaffYearIntegralTotal(param);
        if (studyIntegralVo != null && yearIntegralTotal != null) {
            studyIntegralVo.setYearIntegralTotal(yearIntegralTotal.intValue());
        }
        return studyIntegralVo;
    }

    @Override
    public StaffTodayIntegralVo getStaffTodayIntegral(StudyArchivesSearchParam param) {
        if (!this.hasDailyLoginIntegral(param.getUserId()) && param.getCid() != null) {
            SUserIntegralLog log = new SUserIntegralLog().setUserId(param.getUserId()).setCid(param.getCid()).setUserName(param.getUserLoginName()).setPhone(param.getUserLoginName()).setName(param.getUserName()).setType(UserIntegralTypeEnum.DAILY_LOGIN.getValue()).setIntegral(Integer.valueOf(1)).setObtainDate(new Date());
            this.save(log);
        }
        param.setCid(null);
        return ((SUserIntegralLogMapper)this.baseMapper).getStaffTodayIntegral(param);
    }

    @Override
    public boolean hasDailyLoginIntegral(Long userId) {
        Integer integral = ((SUserIntegralLogMapper)this.baseMapper).getDailyLoginIntegral(userId);
        return integral != null && integral > 0;
    }

    @Override
    public Long getSysUserIdByIdCard(String idCard) {
        return ((SUserIntegralLogMapper)this.baseMapper).getSysUserIdByIdCard(idCard);
    }
}

