/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.radiationTraining.modules.wqxx.service.impl;

import cn.smarthse.framework.mybatisPlus.service.impl.ServiceImpl;
import cn.smarthse.radiationTraining.core.framework.model.LayuiGridData;
import cn.smarthse.radiationTraining.core.framework.model.LayuiGridParam;
import cn.smarthse.radiationTraining.core.framework.utils.DateUtils;
import cn.smarthse.radiationTraining.modules.wqxx.converter.SUserExamConverter;
import cn.smarthse.radiationTraining.modules.wqxx.dao.SUserExamMapper;
import cn.smarthse.radiationTraining.modules.wqxx.entity.SUserExam;
import cn.smarthse.radiationTraining.modules.wqxx.enums.UserExamStateEnum;
import cn.smarthse.radiationTraining.modules.wqxx.enums.UserExamTypeEnum;
import cn.smarthse.radiationTraining.modules.wqxx.model.vo.answerExercise.SUserExamVo;
import cn.smarthse.radiationTraining.modules.wqxx.param.answerExercise.ObtainExamQuestionParam;
import cn.smarthse.radiationTraining.modules.wqxx.service.ISUserExamService;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.github.pagehelper.Page;
import com.github.pagehelper.PageHelper;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class SUserExamServiceImpl
extends ServiceImpl<SUserExamMapper, SUserExam>
implements ISUserExamService {
    @Autowired(required=false)
    private SUserExamConverter userExamConverter;

    @Override
    public LayuiGridData<SUserExamVo> listWeekExam(ObtainExamQuestionParam param) {
        PageHelper.startPage((int)param.getPage(), (int)param.getLimit());
        List<SUserExamVo> rst = ((SUserExamMapper)this.baseMapper).selectAllWeekExamToUser(param);
        return new LayuiGridData((Page)rst, (LayuiGridParam)param);
    }

    @Override
    public SUserExamVo searchWeekUserExam(ObtainExamQuestionParam param) {
        SUserExamVo userExamVo = this.getOneByUserIdAndExamId(param.getUserId(), param.getExamId(), UserExamTypeEnum.WEEKLY_EXAM.getValue());
        if (userExamVo != null) {
            return userExamVo;
        }
        SUserExam entity = new SUserExam();
        entity.setUserId(param.getUserId());
        entity.setCid(param.getCid());
        entity.setExamId(param.getExamId());
        entity.setType(Integer.valueOf(UserExamTypeEnum.WEEKLY_EXAM.getValue()));
        entity.setBeginTime(new Date());
        entity.setObtainDate(new Date());
        entity.setStatus(Integer.valueOf(UserExamStateEnum.INCOMPLETE.getValue()));
        this.save(entity);
        SUserExamVo rst = this.userExamConverter.entity2Vo(entity);
        rst.setIsNewCreate(Boolean.valueOf(true));
        return rst;
    }

    @Override
    public SUserExamVo searchSpecialUserExam(ObtainExamQuestionParam param) {
        SUserExamVo userExamVo = this.getOneByUserIdAndExamId(param.getUserId(), param.getExamId(), UserExamTypeEnum.SPECIAL_EXAM.getValue());
        if (userExamVo != null) {
            return userExamVo;
        }
        SUserExam entity = new SUserExam();
        entity.setUserId(param.getUserId());
        entity.setCid(param.getCid());
        entity.setExamId(param.getExamId());
        entity.setType(Integer.valueOf(UserExamTypeEnum.SPECIAL_EXAM.getValue()));
        entity.setBeginTime(new Date());
        entity.setObtainDate(new Date());
        entity.setStatus(Integer.valueOf(UserExamStateEnum.INCOMPLETE.getValue()));
        this.save(entity);
        SUserExamVo rst = this.userExamConverter.entity2Vo(entity);
        rst.setIsNewCreate(Boolean.valueOf(true));
        return rst;
    }

    @Override
    public LayuiGridData<SUserExamVo> listSpecialExam(ObtainExamQuestionParam param) {
        PageHelper.startPage((int)param.getPage(), (int)param.getLimit());
        List<SUserExamVo> rst = ((SUserExamMapper)this.baseMapper).selectAllSpecialExamToUser(param);
        return new LayuiGridData((Page)rst, (LayuiGridParam)param);
    }

    @Override
    public SUserExamVo genUserExam(ObtainExamQuestionParam param) {
        if (param.getUserExamId() != null) {
            return this.userExamConverter.entity2Vo((SUserExam)this.getById(param.getUserExamId()));
        }
        SUserExam entity = new SUserExam();
        entity.setUserId(param.getUserId());
        entity.setCid(param.getCid());
        entity.setExamId(param.getExamId());
        entity.setType(param.getType());
        entity.setBeginTime(new Date());
        entity.setObtainDate(new Date());
        entity.setStatus(Integer.valueOf(1));
        this.save(entity);
        return this.userExamConverter.entity2Vo(entity);
    }

    @Override
    public boolean judgeScoreStatusByExamType(Long userId, Long cid, Long examId, Integer examType) {
        List<SUserExamVo> userExamList;
        if (examType.intValue() == UserExamTypeEnum.WEEKLY_EXAM.getValue()) {
            userExamList = ((SUserExamMapper)this.baseMapper).searchAllByDateAndType(userId, cid, examType, DateUtils.getMondayDateInThisWeek(), DateUtils.getSundayDateInThisWeek());
            if (CollectionUtils.isEmpty(userExamList)) {
                return false;
            }
            for (SUserExamVo userExam : userExamList) {
                if (userExam.getScoreStatus() != 2) continue;
                return true;
            }
        }
        if (examType.intValue() == UserExamTypeEnum.SPECIAL_EXAM.getValue()) {
            LambdaQueryWrapper wrapper = new LambdaQueryWrapper();
            ((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)wrapper.eq(SUserExam::getUserId, (Object)userId)).eq(SUserExam::getCid, (Object)cid)).eq(SUserExam::getType, (Object)examType)).eq(SUserExam::getExamId, (Object)examId)).ge(SUserExam::getObtainDate, (Object)DateUtils.getMondayDateInThisWeek())).le(SUserExam::getObtainDate, (Object)DateUtils.getSundayDateInThisWeek());
            List userExamList2 = this.list((Wrapper)wrapper);
            if (CollectionUtils.isEmpty((Collection)userExamList2)) {
                return false;
            }
            for (SUserExamVo userExam : userExamList2) {
                if (userExam.getScoreStatus() != 2) continue;
                return true;
            }
        }
        if (examType.intValue() == UserExamTypeEnum.CHALLENGE_EXAM.getValue()) {
            userExamList = ((SUserExamMapper)this.baseMapper).searchAllByDateAndType(userId, cid, examType, new Date(), null);
            if (CollectionUtils.isEmpty(userExamList)) {
                return false;
            }
            int score = 0;
            for (SUserExamVo userExam : userExamList) {
                if (userExam.getScoreStatus() != 2) continue;
                score += userExam.getTotalScore().intValue();
            }
            return score >= 5;
        }
        return false;
    }

    @Override
    public boolean judgeScoreStatusByExamType(SUserExam userExam) {
        List<SUserExamVo> userExamList;
        Integer examType = userExam.getType();
        Long userId = userExam.getUserId();
        Long cid = userExam.getCid();
        Long examId = userExam.getExamId();
        if (examType.intValue() == UserExamTypeEnum.WEEKLY_EXAM.getValue()) {
            userExamList = ((SUserExamMapper)this.baseMapper).searchAllForWeeklyExam(userId, null, examId, null, null);
            if (CollectionUtils.isEmpty(userExamList)) {
                return false;
            }
            for (SUserExamVo vo : userExamList) {
                if (vo.getScoreStatus() != 2) continue;
                return true;
            }
        }
        if (examType.intValue() == UserExamTypeEnum.SPECIAL_EXAM.getValue()) {
            LambdaQueryWrapper wrapper = new LambdaQueryWrapper();
            ((LambdaQueryWrapper)((LambdaQueryWrapper)wrapper.eq(SUserExam::getUserId, (Object)userId)).eq(SUserExam::getType, (Object)examType)).eq(SUserExam::getExamId, (Object)examId);
            List userExamList2 = this.list((Wrapper)wrapper);
            if (CollectionUtils.isEmpty((Collection)userExamList2)) {
                return false;
            }
            for (SUserExamVo vo : userExamList2) {
                if (vo.getScoreStatus() != 2) continue;
                return true;
            }
        }
        if (examType.intValue() == UserExamTypeEnum.CHALLENGE_EXAM.getValue()) {
            userExamList = ((SUserExamMapper)this.baseMapper).searchAllForChallengeExam(userId, null, new Date());
            if (CollectionUtils.isEmpty(userExamList)) {
                return false;
            }
            int score = 0;
            for (SUserExamVo vo : userExamList) {
                if (vo.getScoreStatus() != 2) continue;
                score += vo.getTotalScore().intValue();
            }
            return score >= 5;
        }
        return false;
    }

    @Override
    public SUserExamVo getOneByUserIdAndExamId(Long userId, Long examId, Integer type) {
        if (examId == null) {
            return null;
        }
        return ((SUserExamMapper)this.baseMapper).selectOneByUserIdAndExamId(userId, examId, type);
    }

    @Override
    public List<Long> listUserIdByWeeklyExamIdAndStatus(Long examId, Integer status) {
        return ((SUserExamMapper)this.baseMapper).listUserIdByExamIdAndStatus(examId, status);
    }

    @Override
    public List<SUserExam> handleTestingUserExam(Long examId) {
        LambdaQueryWrapper wrapper = new LambdaQueryWrapper();
        ((LambdaQueryWrapper)wrapper.eq(SUserExam::getExamId, (Object)examId)).eq(SUserExam::getStatus, (Object)UserExamStateEnum.INCOMPLETE.getValue());
        List userExamList = this.list((Wrapper)wrapper);
        return userExamList;
    }

    @Override
    public List<SUserExam> genUserExamForTask(Long examId, List<Long> userIdList) {
        ArrayList<SUserExam> entityList = new ArrayList<SUserExam>();
        userIdList.stream().forEach(userId -> {
            SUserExam entity = new SUserExam();
            entity.setUserId(userId);
            entity.setExamId(examId);
            entity.setType(Integer.valueOf(UserExamTypeEnum.WEEKLY_EXAM.getValue()));
            entity.setBeginTime(new Date());
            entity.setObtainDate(new Date());
            entity.setStatus(Integer.valueOf(UserExamStateEnum.DONE.getValue()));
            entity.setDoneType(Integer.valueOf(1));
            entity.setScoreStatus(Integer.valueOf(1));
            entity.setRightNum(Integer.valueOf(0));
            entityList.add(entity);
        });
        this.saveBatch(entityList);
        return entityList;
    }
}

