/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.radiationTraining.modules.wqxx.service.impl;

import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.http.HtmlUtil;
import cn.smarthse.framework.mybatisPlus.service.impl.ServiceImpl;
import cn.smarthse.framework.oss.bean.OssClientBean;
import cn.smarthse.radiationTraining.core.framework.model.LayuiGridData;
import cn.smarthse.radiationTraining.core.framework.model.LayuiGridParam;
import cn.smarthse.radiationTraining.core.framework.utils.StringUtils;
import cn.smarthse.radiationTraining.modules.sys.provider.sys.ISysFileProvideService;
import cn.smarthse.radiationTraining.modules.wqxx.converter.SArticleVideoConverter;
import cn.smarthse.radiationTraining.modules.wqxx.dao.SArticleVideoMapper;
import cn.smarthse.radiationTraining.modules.wqxx.entity.SArticleVideo;
import cn.smarthse.radiationTraining.modules.wqxx.model.vo.articleVideo.ArticleVideoListVo;
import cn.smarthse.radiationTraining.modules.wqxx.model.vo.articleVideo.ArticleVideoVo;
import cn.smarthse.radiationTraining.modules.wqxx.param.SArticle.SArticleVideoBatchAdminParam;
import cn.smarthse.radiationTraining.modules.wqxx.param.SArticle.SArticleVideoEditAdminParam;
import cn.smarthse.radiationTraining.modules.wqxx.param.SArticle.SArticleVideoListAdminParam;
import cn.smarthse.radiationTraining.modules.wqxx.param.articleVideoStudy.ArticleListForUserSearchParam;
import cn.smarthse.radiationTraining.modules.wqxx.service.ISArticleVideoService;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.core.conditions.update.UpdateWrapper;
import com.github.pagehelper.Page;
import com.github.pagehelper.PageHelper;
import java.util.Collection;
import java.util.Date;
import javax.smarthse.framework.exception.ServiceException;
import org.apache.dubbo.config.annotation.DubboReference;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional(readOnly=true)
public class SArticleVideoServiceImpl
extends ServiceImpl<SArticleVideoMapper, SArticleVideo>
implements ISArticleVideoService {
    @Autowired(required=false)
    private SArticleVideoConverter articleVideoConverter;
    @Autowired
    private OssClientBean ossClientBean;
    @DubboReference
    private ISysFileProvideService sysFileProvideService;

    @Override
    @Transactional
    public SArticleVideo addForAdmin(SArticleVideoEditAdminParam param) {
        SArticleVideo sArticleVideo = this.articleVideoConverter.editParam2Entity(param);
        sArticleVideo.setReleaseDate(new Date());
        sArticleVideo.setReleaser(param.getLoginUsername());
        sArticleVideo.setReleaseBy(param.getLoginUserId());
        sArticleVideo.setCreateBy(param.getLoginUserId());
        sArticleVideo.setUpdateBy(param.getLoginUserId());
        this.save(sArticleVideo);
        return sArticleVideo;
    }

    @Override
    @Transactional
    public SArticleVideo editForAdmin(SArticleVideoEditAdminParam param) {
        if (param.getId() == null) {
            throw new ServiceException("id\u4e0d\u80fd\u4e3a\u7a7a");
        }
        SArticleVideo sArticleVideo = this.articleVideoConverter.editParam2Entity(param);
        sArticleVideo.setReleaseDate(new Date());
        sArticleVideo.setReleaser(param.getLoginUsername());
        sArticleVideo.setReleaseBy(param.getLoginUserId());
        sArticleVideo.setCreateBy(param.getLoginUserId());
        sArticleVideo.setUpdateBy(param.getLoginUserId());
        this.updateById(sArticleVideo);
        return sArticleVideo;
    }

    private static void dealXXS(SArticleVideo sArticleVideo) {
        sArticleVideo.setContent(HtmlUtil.escape((String)sArticleVideo.getContent()));
        sArticleVideo.setTitle(HtmlUtil.removeHtmlTag((String)sArticleVideo.getTitle(), (String[])new String[0]));
        sArticleVideo.setType(HtmlUtil.removeHtmlTag((String)sArticleVideo.getType(), (String[])new String[0]));
        sArticleVideo.setItype(HtmlUtil.removeHtmlTag((String)sArticleVideo.getItype(), (String[])new String[0]));
        sArticleVideo.setScreenshotIds(HtmlUtil.removeHtmlTag((String)sArticleVideo.getScreenshotIds(), (String[])new String[0]));
        sArticleVideo.setFileIds(HtmlUtil.removeHtmlTag((String)sArticleVideo.getFileIds(), (String[])new String[0]));
        sArticleVideo.setAuthor(HtmlUtil.removeHtmlTag((String)sArticleVideo.getAuthor(), (String[])new String[0]));
        sArticleVideo.setReleaser(HtmlUtil.removeHtmlTag((String)sArticleVideo.getReleaser(), (String[])new String[0]));
    }

    @Override
    @Transactional
    public void delBatchForAdmin(SArticleVideoBatchAdminParam param) {
        if (CollectionUtil.isEmpty((Collection)param.getIdList())) {
            throw new ServiceException("id\u4e0d\u80fd\u4e3a\u7a7a");
        }
        UpdateWrapper wrapper = new UpdateWrapper();
        ((LambdaUpdateWrapper)wrapper.lambda().set(SArticleVideo::getUpdateBy, (Object)param.getLoginUserId())).in(SArticleVideo::getId, (Collection)param.getIdList());
        this.update((Wrapper)wrapper);
        this.removeByIds(param.getIdList());
    }

    @Override
    @Transactional
    public void upOrDownBatchForAdmin(SArticleVideoBatchAdminParam param) {
        if (CollectionUtil.isEmpty((Collection)param.getIdList())) {
            throw new ServiceException("id\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (param.getOptType() == null || param.getOptType() != 1 && param.getOptType() != 2) {
            throw new ServiceException("\u64cd\u4f5c\u7c7b\u578b\u9519\u8bef");
        }
        Integer state = param.getOptType() == 1 ? 1 : 2;
        UpdateWrapper wrapper = new UpdateWrapper();
        ((LambdaUpdateWrapper)((LambdaUpdateWrapper)wrapper.lambda().set(SArticleVideo::getUpdateBy, (Object)param.getLoginUserId())).set(SArticleVideo::getState, (Object)state)).in(SArticleVideo::getId, (Collection)param.getIdList());
        this.update((Wrapper)wrapper);
    }

    @Override
    public LayuiGridData<ArticleVideoVo> listForAdmin(SArticleVideoListAdminParam param) {
        PageHelper.startPage((int)param.getPage(), (int)param.getLimit());
        return new LayuiGridData((Page)((SArticleVideoMapper)this.baseMapper).listForAdmin(param), (LayuiGridParam)param);
    }

    @Override
    public ArticleVideoVo getDetailForAdmin(Long id) {
        ArticleVideoVo detailForAdmin = ((SArticleVideoMapper)this.baseMapper).getDetailForAdmin(id);
        if (detailForAdmin != null) {
            if (!StringUtils.isEmpty((CharSequence)detailForAdmin.getScreenshotIds())) {
                detailForAdmin.setScreenshotUrl(this.sysFileProvideService.getFileUrl(Long.valueOf(detailForAdmin.getScreenshotIds())));
            }
            if (!StringUtils.isEmpty((CharSequence)detailForAdmin.getFileIds())) {
                detailForAdmin.setFileUrl(this.sysFileProvideService.getFileUrl(Long.valueOf(detailForAdmin.getFileIds())));
            }
        }
        detailForAdmin.setContent(HtmlUtil.unescape((String)detailForAdmin.getContent()));
        return detailForAdmin;
    }

    @Override
    public LayuiGridData<ArticleVideoListVo> listArticleVideoPageForUser(ArticleListForUserSearchParam param) {
        PageHelper.startPage((int)param.getPage(), (int)param.getLimit());
        return new LayuiGridData((Page)((SArticleVideoMapper)this.baseMapper).selectBatchArticleForUser(param), (LayuiGridParam)param);
    }

    @Override
    public ArticleVideoVo getArticleVideoDetailForUser(ArticleListForUserSearchParam param) {
        ArticleVideoVo detailForWxUser = ((SArticleVideoMapper)this.baseMapper).getDetailForWxUser(param.getId(), param.getUid(), new Date());
        detailForWxUser.setContent(HtmlUtil.unescape((String)detailForWxUser.getContent()));
        return detailForWxUser;
    }
}

