/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.radiationTraining.modules.wqxx.provider.articleVideo;

import cn.smarthse.radiationTraining.core.framework.model.LayuiGridData;
import cn.smarthse.radiationTraining.modules.sys.provider.sys.ISysFileProvideService;
import cn.smarthse.radiationTraining.modules.wqxx.entity.SArticleVideo;
import cn.smarthse.radiationTraining.modules.wqxx.entity.SUserIntegralLog;
import cn.smarthse.radiationTraining.modules.wqxx.enums.UserIntegralTypeEnum;
import cn.smarthse.radiationTraining.modules.wqxx.enums.UserLearnStateEnum;
import cn.smarthse.radiationTraining.modules.wqxx.model.vo.articleVideo.ArticleVideoListVo;
import cn.smarthse.radiationTraining.modules.wqxx.model.vo.articleVideo.ArticleVideoVo;
import cn.smarthse.radiationTraining.modules.wqxx.model.vo.articleVideo.EarnIntegralVo;
import cn.smarthse.radiationTraining.modules.wqxx.param.SArticle.SArticleVideoBatchAdminParam;
import cn.smarthse.radiationTraining.modules.wqxx.param.SArticle.SArticleVideoEditAdminParam;
import cn.smarthse.radiationTraining.modules.wqxx.param.SArticle.SArticleVideoListAdminParam;
import cn.smarthse.radiationTraining.modules.wqxx.param.articleVideoStudy.ArticleListForUserSearchParam;
import cn.smarthse.radiationTraining.modules.wqxx.param.articleVideoStudy.EarnIntegralParam;
import cn.smarthse.radiationTraining.modules.wqxx.provider.articleVideo.IArticleVideoProviderService;
import cn.smarthse.radiationTraining.modules.wqxx.service.ISArticleVideoService;
import cn.smarthse.radiationTraining.modules.wqxx.service.ISUserIntegralLogService;
import cn.smarthse.radiationTraining.modules.wqxx.service.ISUserLearnService;
import java.util.Collection;
import java.util.Date;
import org.apache.dubbo.config.annotation.DubboReference;
import org.apache.dubbo.config.annotation.DubboService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

@DubboService
public class IArticleVideoProviderServiceImpl
implements IArticleVideoProviderService {
    @Autowired
    private ISArticleVideoService articleVideoService;
    @Autowired
    private ISUserLearnService userLearnService;
    @Autowired
    private ISUserIntegralLogService integralLogService;
    @DubboReference
    private ISysFileProvideService sysFileProvideService;

    @Transactional
    public SArticleVideo addForAdmin(SArticleVideoEditAdminParam param) {
        return this.articleVideoService.addForAdmin(param);
    }

    @Transactional
    public SArticleVideo editForAdmin(SArticleVideoEditAdminParam param) {
        return this.articleVideoService.editForAdmin(param);
    }

    @Transactional
    public void delBatchForAdmin(SArticleVideoBatchAdminParam param) {
        this.articleVideoService.delBatchForAdmin(param);
    }

    public void upOrDownBatchForAdmin(SArticleVideoBatchAdminParam param) {
        this.articleVideoService.upOrDownBatchForAdmin(param);
    }

    public LayuiGridData<ArticleVideoVo> listForAdmin(SArticleVideoListAdminParam param) {
        return this.articleVideoService.listForAdmin(param);
    }

    public ArticleVideoVo getDetailForAdmin(Long id) {
        return this.articleVideoService.getDetailForAdmin(id);
    }

    public LayuiGridData<ArticleVideoListVo> listArticleVideoForUser(ArticleListForUserSearchParam param) {
        LayuiGridData<ArticleVideoListVo> rstList = this.articleVideoService.listArticleVideoPageForUser(param);
        if (!CollectionUtils.isEmpty((Collection)rstList.getData())) {
            for (ArticleVideoListVo vo : rstList.getData()) {
                if (vo.getScreenshotIds() == null || vo.getScreenshotIds().equals("")) continue;
                vo.setScreenshotUrl(this.sysFileProvideService.getFileUrl(Long.valueOf(vo.getScreenshotIds())));
            }
        }
        return rstList;
    }

    public ArticleVideoVo getArticleVideoDetailForUser(ArticleListForUserSearchParam param) {
        ArticleVideoVo rst = this.articleVideoService.getArticleVideoDetailForUser(param);
        if (rst != null && rst.getScreenshotIds() != null && !rst.getScreenshotIds().equals("")) {
            rst.setScreenshotUrl(this.sysFileProvideService.getFileUrl(Long.valueOf(rst.getScreenshotIds())));
        }
        if (rst != null && rst.getFileIds() != null && !rst.getFileIds().equals("")) {
            rst.setFileUrl(this.sysFileProvideService.getFileUrl(Long.valueOf(rst.getFileIds())));
        }
        return rst;
    }

    public EarnIntegralVo earnIntegralFromArticleVideoOld(EarnIntegralParam param) {
        EarnIntegralVo learnInfo = this.userLearnService.getLearnInfoForUser(param.getBusinessId(), param.getUserId());
        if (learnInfo.getId() == null) {
            param.setLearnDate(new Date());
            this.userLearnService.addUserLearn(param);
            if (param.getState() == 2) {
                SUserIntegralLog integralLog = this.initIntLog(param);
                this.integralLogService.addIntegralByStudy(integralLog);
            }
        } else if (!learnInfo.getHasLearned().booleanValue() && param.getState().intValue() == UserLearnStateEnum.DONE.getValue()) {
            SUserIntegralLog integralLog = this.initIntLog(param);
            param.setId(learnInfo.getId());
            this.userLearnService.updateUserLearn(param);
            this.integralLogService.addIntegralByStudy(integralLog);
        } else if (!learnInfo.getHasLearned().booleanValue() && param.getType() == 2 && param.getState().intValue() == UserLearnStateEnum.INCOMPLETE.getValue()) {
            param.setId(learnInfo.getId());
            this.userLearnService.updateVideoLearnTime(param);
        }
        return null;
    }

    public EarnIntegralVo earnIntegralFromArticleVideo(EarnIntegralParam param) {
        boolean hasObtained = this.integralLogService.judgeObtainIntegralForStudy(param.getUserId(), param.getType());
        if (!hasObtained) {
            this.integralLogService.addIntegralByStudy(this.initIntLog(param));
            param.setLearnDate(new Date());
            this.userLearnService.addUserLearn(param);
        }
        return null;
    }

    private SUserIntegralLog initIntLog(EarnIntegralParam param) {
        SUserIntegralLog integralLog = new SUserIntegralLog(param.getUserId(), null, null, param.getBusinessId());
        integralLog.setCid(param.getCid());
        integralLog.setName(param.getName());
        integralLog.setUserName(param.getUserName());
        integralLog.setPhone(param.getPhone());
        integralLog.setObtainDate(new Date());
        if (param.getType() == 1) {
            integralLog.setType(UserIntegralTypeEnum.ARTICLE_LEARN.getValue());
            integralLog.setIntegral(Integer.valueOf(1));
        }
        if (param.getType() == 2) {
            integralLog.setType(UserIntegralTypeEnum.VIDEO_LEARN.getValue());
            integralLog.setIntegral(Integer.valueOf(5));
        }
        return integralLog;
    }
}

