/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.radiationTraining.modules.training.task.cert.offline;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.util.StrUtil;
import cn.smarthse.radiationTraining.modules.training.entity.certificate.RaTuCertificate;
import cn.smarthse.radiationTraining.modules.training.enums.TrainingPersonTypeEnum;
import cn.smarthse.radiationTraining.modules.training.service.certificate.IRaTuCertificateService;
import cn.smarthse.radiationTraining.modules.training.task.cert.offline.CertOfflineRayService;
import cn.smarthse.radiationTraining.modules.training.task.cert.offline.CertOfflineUnitService;
import java.util.List;
import javax.smarthse.framework.exception.ServiceException;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class CertOfflineService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(CertOfflineService.class);
    @Autowired
    private IRaTuCertificateService offlineCertificateService;
    @Autowired
    private CertOfflineUnitService certOfflineUnitService;
    @Autowired
    private CertOfflineRayService certOfflineRayService;

    public void genCertFileBatch() {
        List<Long> dataList = this.offlineCertificateService.listNeedGenCertForOffline();
        if (CollectionUtils.isEmpty(dataList)) {
            return;
        }
        for (int index = 0; index < dataList.size(); ++index) {
            Long id = dataList.get(index);
            try {
                this.genCertFile(id);
                continue;
            }
            catch (Exception e) {
                log.error("\u3010\u7ebf\u4e0b\u8bc1\u4e66\u751f\u6210\u3011\u3010\u5931\u8d25\u3011 certId\uff1a{}\uff0ce\uff1a{}", (Object)id, (Object)e);
            }
        }
    }

    public void genCertFile(Long certId) {
        RaTuCertificate db = (RaTuCertificate)this.offlineCertificateService.getById(certId);
        if (db == null) {
            throw new ServiceException("\u6570\u636e\u4e0d\u5b58\u5728");
        }
        String certType = db.getCertType();
        if (certType == null) {
            throw new ServiceException("\u8bc1\u4e66\u7c7b\u578b\u4e0d\u5b58\u5728");
        }
        if (StrUtil.equals((CharSequence)certType, (CharSequence)TrainingPersonTypeEnum.MAIN_IN_CHARGE.getValue()) || StrUtil.equals((CharSequence)certType, (CharSequence)TrainingPersonTypeEnum.HEALTH_ADMIN.getValue())) {
            this.certOfflineUnitService.genCert(db);
        } else if (StrUtil.equals((CharSequence)certType, (CharSequence)TrainingPersonTypeEnum.RAY_WORK.getValue())) {
            this.certOfflineRayService.genCert(db);
        } else {
            throw new ServiceException("\u8bc1\u4e66\u7c7b\u578b\u9519\u8bef");
        }
    }

    public void syncCertFileBytTid(Long tid) {
        List<Long> certIdList = this.offlineCertificateService.getListByTidForSyncCert(tid);
        if (CollUtil.isEmpty(certIdList)) {
            return;
        }
        StringBuilder sb = new StringBuilder();
        for (Long certId : certIdList) {
            String result = this.syncCertFile(certId);
            if (!StrUtil.isNotBlank((CharSequence)result)) continue;
            sb.append(result).append(".");
        }
        if (sb.length() > 0) {
            throw new ServiceException(sb.toString());
        }
    }

    public String syncCertFile(Long certId) {
        RaTuCertificate db = (RaTuCertificate)this.offlineCertificateService.getById(certId);
        if (db == null) {
            throw new ServiceException("\u6570\u636e\u4e0d\u5b58\u5728");
        }
        String certType = db.getCertType();
        if (certType == null) {
            throw new ServiceException("\u8bc1\u4e66\u7c7b\u578b\u4e0d\u5b58\u5728");
        }
        String errResult = null;
        if (StrUtil.equals((CharSequence)certType, (CharSequence)TrainingPersonTypeEnum.MAIN_IN_CHARGE.getValue()) || StrUtil.equals((CharSequence)certType, (CharSequence)TrainingPersonTypeEnum.HEALTH_ADMIN.getValue())) {
            errResult = this.certOfflineUnitService.syncCertInfo(db);
        } else if (StrUtil.equals((CharSequence)certType, (CharSequence)TrainingPersonTypeEnum.RAY_WORK.getValue())) {
            errResult = this.certOfflineRayService.syncCertInfo(db);
        } else {
            throw new ServiceException("\u8bc1\u4e66\u7c7b\u578b\u9519\u8bef");
        }
        if (StrUtil.isNotBlank((CharSequence)errResult)) {
            return db.getUname() + ":" + errResult;
        }
        return null;
    }

    @Generated
    public CertOfflineService() {
    }
}

