/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.radiationTraining.modules.training.task.cert.offline;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.date.DateUtil;
import cn.hutool.core.io.resource.ResourceUtil;
import cn.hutool.core.util.DesensitizedUtil;
import cn.hutool.core.util.IdUtil;
import cn.hutool.core.util.IdcardUtil;
import cn.hutool.core.util.StrUtil;
import cn.hutool.crypto.digest.MD5;
import cn.hutool.extra.qrcode.QrCodeUtil;
import cn.hutool.extra.qrcode.QrConfig;
import cn.smarthse.framework.oss.bean.OssClientBean;
import cn.smarthse.modules.uploader.FileResourceEnum;
import cn.smarthse.modules.uploader.FileUploadSimple;
import cn.smarthse.modules.uploader.UploadFileParameter;
import cn.smarthse.modules.uploader.UploadFilePathEnum;
import cn.smarthse.radiationTraining.core.framework.bootstrap.properties.SysProperties;
import cn.smarthse.radiationTraining.core.framework.utils.FreemarkUtil;
import cn.smarthse.radiationTraining.core.framework.utils.StringUtils;
import cn.smarthse.radiationTraining.modules.sys.entity.sys.SysFile;
import cn.smarthse.radiationTraining.modules.sys.provider.hse.IHseCompanyProviderService;
import cn.smarthse.radiationTraining.modules.sys.provider.sys.ISysFileProvideService;
import cn.smarthse.radiationTraining.modules.sys.vo.hse.HseCompanyVo;
import cn.smarthse.radiationTraining.modules.sys.vo.sys.SysFileModel;
import cn.smarthse.radiationTraining.modules.training.entity.certificate.RaTuCertificate;
import cn.smarthse.radiationTraining.modules.training.entity.certificate.TuCertificate;
import cn.smarthse.radiationTraining.modules.training.entity.training.RaTraining;
import cn.smarthse.radiationTraining.modules.training.enums.CertBgEnum;
import cn.smarthse.radiationTraining.modules.training.enums.TrainingPersonTypeEnum;
import cn.smarthse.radiationTraining.modules.training.service.certificate.IRaTuCertificateService;
import cn.smarthse.radiationTraining.modules.training.service.certificate.ITuCertificateService;
import cn.smarthse.radiationTraining.modules.training.service.training.IRaTrainingService;
import cn.smarthse.radiationTraining.modules.training.task.CertService;
import cn.smarthse.radiationTraining.modules.training.vo.certificate.OfflineCertConfig;
import cn.smarthse.rho.modules.sys.model.c.param.TrainingOfflineCertSyncParam;
import cn.smarthse.rho.modules.sys.provider.sync.ITrainingSyncProvider;
import com.itextpdf.html2pdf.ConverterProperties;
import com.itextpdf.html2pdf.HtmlConverter;
import com.itextpdf.kernel.geom.PageSize;
import com.itextpdf.kernel.pdf.PdfDocument;
import com.itextpdf.kernel.pdf.PdfWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Lock;
import javax.smarthse.framework.exception.ServiceException;
import lombok.Generated;
import org.apache.commons.io.FilenameUtils;
import org.apache.dubbo.config.annotation.DubboReference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.integration.redis.util.RedisLockRegistry;
import org.springframework.scheduling.concurrent.ThreadPoolTaskExecutor;
import org.springframework.stereotype.Service;

@Service
public class CertOfflineRayService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(CertOfflineRayService.class);
    @Autowired
    private ThreadPoolTaskExecutor threadPoolTaskExecutor;
    @Autowired
    private OssClientBean ossClientBean;
    @Autowired
    private SysProperties sysProperties;
    @Autowired
    private IRaTuCertificateService offlineCertificateService;
    @Autowired
    private ITuCertificateService onlineCertificateService;
    @Autowired
    private IRaTrainingService raTrainingService;
    @Autowired
    private IRaTrainingService trainingService;
    @DubboReference
    private IHseCompanyProviderService hseCompanyProviderService;
    @DubboReference
    private ITrainingSyncProvider rayTrainingSyncProvider;
    @DubboReference
    private ISysFileProvideService sysFileProvideService;
    @Autowired
    RedisLockRegistry lockRegistry;
    public static final String certFont = "templates/ali/AlibabaPuHuiTi-3-55-Regular.ttf";

    public void genCert(Long certId) {
        RaTuCertificate db = (RaTuCertificate)this.offlineCertificateService.getById(certId);
        if (db == null) {
            throw new ServiceException("\u6570\u636e\u4e0d\u5b58\u5728");
        }
        this.genCert(db);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void genCert(RaTuCertificate record) {
        Lock lock;
        String lock_key;
        block16: {
            if (record == null) {
                return;
            }
            if (StringUtils.isNotEmpty((String)record.getPdfUrl())) {
                return;
            }
            if (record.getTrainingResult() == null || record.getTrainingResult() != 1) {
                return;
            }
            if (record.getStatus() == null || record.getStatus() != 2) {
                return;
            }
            if (StrUtil.isBlank((CharSequence)record.getCertType())) {
                log.error("\u3010\u7ebf\u4e0b\u8bc1\u4e66\u751f\u6210\u3011\u3010\u533b\u9662\u3011\u8bc1\u4e66\u7c7b\u578b\u7f3a\u5931\uff1acertId:{}", (Object)record.getId());
                return;
            }
            if (!StrUtil.equals((CharSequence)record.getCertType(), (CharSequence)TrainingPersonTypeEnum.RAY_WORK.getValue())) {
                return;
            }
            if (record.getIssueTime() == null) {
                log.error("\u3010\u7ebf\u4e0b\u8bc1\u4e66\u751f\u6210\u3011\u3010\u533b\u9662\u3011\u53d1\u8bc1\u65e5\u671f\u7f3a\u5931\uff1acertId:{}", (Object)record.getId());
                return;
            }
            if (record.getInvalidDate() == null) {
                log.error("\u3010\u7ebf\u4e0b\u8bc1\u4e66\u751f\u6210\u3011\u3010\u533b\u9662\u3011\u53d1\u8bc1\u65e5\u671f\u7f3a\u5931\uff1acertId:{}", (Object)record.getId());
                return;
            }
            Long tid = record.getTid();
            Long cid = record.getCid();
            Long certId = record.getTid();
            Integer year = DateUtil.year((Date)record.getIssueTime());
            RaTraining training = (RaTraining)this.raTrainingService.getById(tid);
            if (training == null) {
                log.error("\u3010\u7ebf\u4e0b\u8bc1\u4e66\u751f\u6210\u3011\u3010\u533b\u9662\u3011\u57f9\u8bad\u4fe1\u606f\u7f3a\u5931\uff1acertId:{}\uff0ctid:{}", (Object)record.getId(), (Object)record.getTid());
                return;
            }
            HseCompanyVo hseCompanyVo = this.hseCompanyProviderService.getInfoById(cid);
            if (hseCompanyVo == null) {
                log.error("\u3010\u7ebf\u4e0b\u8bc1\u4e66\u751f\u6210\u3011\u3010\u533b\u9662\u3011\u5355\u4f4d\u4e0d\u5b58\u5728,certId\uff1a{},cid:{}", (Object)certId, (Object)cid);
                return;
            }
            Long areaId = hseCompanyVo.getAreaId();
            if (areaId == null) {
                log.error("\u3010\u7ebf\u4e0b\u8bc1\u4e66\u751f\u6210\u3011\u3010\u533b\u9662\u3011\u5355\u4f4d\u884c\u653f\u533a\u5212id\u4e0d\u5b58\u5728,certId\uff1a{},cid:{}", (Object)certId, (Object)cid);
                return;
            }
            if (areaId.toString().length() < 6) {
                log.error("\u3010\u7ebf\u4e0b\u8bc1\u4e66\u751f\u6210\u3011\u3010\u533b\u9662\u3011\u884c\u653f\u533a\u5212\u7f16\u7801\u683c\u5f0f\u4e0d\u6b63\u786e\uff0ccertId{}\uff0careaId\uff1a{} - cid\uff1a{}", new Object[]{certId, areaId, cid});
                return;
            }
            this.idCardProcessing(record);
            record.setYear(year);
            lock_key = CertService.getKey(areaId, year, record.getCertType());
            lock = this.lockRegistry.obtain((Object)lock_key);
            try {
                if (!lock.tryLock(10L, TimeUnit.MINUTES)) break block16;
                log.debug("\u751f\u6210\u8bc1\u4e66\u7f16\u53f7-\u83b7\u53d6\u9501\uff1akey:\u201c{}\u201c-id:{}-uname\uff1a{}", new Object[]{lock_key, record.getId(), record.getUname()});
                this.genCertFile(record, hseCompanyVo);
            }
            catch (Exception e) {
                try {
                    log.error("\u3010\u7ebf\u4e0b\u8bc1\u4e66\u751f\u6210\u3011\u3010\u533b\u9662\u3011\u6587\u4ef6\u751f\u6210\u5931\u8d25e\uff1a{}", (Throwable)e);
                }
                catch (Throwable throwable) {
                    log.debug("\u751f\u6210\u8bc1\u4e66\u7f16\u53f7-\u91ca\u653e\u9501\uff1akey:\u201c{}\u201c-id:{}-uname:{}", new Object[]{lock_key, record.getId(), record.getUname()});
                    lock.unlock();
                    throw throwable;
                }
                log.debug("\u751f\u6210\u8bc1\u4e66\u7f16\u53f7-\u91ca\u653e\u9501\uff1akey:\u201c{}\u201c-id:{}-uname:{}", new Object[]{lock_key, record.getId(), record.getUname()});
                lock.unlock();
            }
        }
        log.debug("\u751f\u6210\u8bc1\u4e66\u7f16\u53f7-\u91ca\u653e\u9501\uff1akey:\u201c{}\u201c-id:{}-uname:{}", new Object[]{lock_key, record.getId(), record.getUname()});
        lock.unlock();
    }

    private void idCardProcessing(RaTuCertificate record) {
        String idcard = record.getIdCard();
        if (StrUtil.isNotBlank((CharSequence)idcard)) {
            int length;
            record.setIdCard(idcard);
            boolean validCard = IdcardUtil.isValidCard((String)idcard);
            Object desensitizationIdCard = null;
            desensitizationIdCard = validCard && StrUtil.length((CharSequence)idcard) == 18 ? DesensitizedUtil.idCardNum((String)idcard, (int)1, (int)2) : ((length = StrUtil.length((CharSequence)idcard)) >= 3 ? DesensitizedUtil.idCardNum((String)idcard, (int)1, (int)1) : StrUtil.subPre((CharSequence)idcard, (int)1) + "***");
            record.setDesensitizationIdCard((String)desensitizationIdCard);
        } else {
            record.setIdCard("         -        ");
            record.setDesensitizationIdCard("         -        ");
        }
    }

    private void genCertFile(RaTuCertificate record, HseCompanyVo hseCompanyVo) {
        if (StringUtils.isEmpty((CharSequence)record.getCertificateNo())) {
            TuCertificate certificateNo = this.onlineCertificateService.getCertificateNoV2ForRay(hseCompanyVo.getAreaId(), DateUtil.year((Date)record.getIssueTime()), record.getCertType());
            record.setAreaId(certificateNo.getAreaId());
            record.setYear(certificateNo.getYear());
            record.setSerialNo(certificateNo.getSerialNo());
            record.setCertificateNo(certificateNo.getCertificateNo());
            this.updateCertificateNo(record);
        }
        CertBgEnum certBgEnum = CertBgEnum.RAY_WORK_V2;
        record.setBackgroundId(certBgEnum.getValue());
        record.setSealUrl(this.ossClientBean.getUrl("upload/radiationTraining/common/20250821/02c3e17d-15bb-4740-a27c-3f8fb82cb238-dzgz.png"));
        this.checkGenResult(record);
        this.genCertPdfFile(record);
    }

    private void genCertPdfFile(RaTuCertificate record) {
        File file = this.genCertFile(record);
        SysFileModel pdfSysFile = this.uploadBackstage(file, file.getName());
        record.setPdfFileId(pdfSysFile.getId());
        record.setPdfUrl(pdfSysFile.getOssUrl());
        record.setUpdateDate(LocalDateTime.now());
        this.checkGenResult(record);
        this.offlineCertificateService.updateById(record);
    }

    private void checkGenResult(RaTuCertificate record) {
        List<TuCertificate> list = this.onlineCertificateService.getByCertificateNoForCheckResult(record.getCertificateNo());
        boolean isError = false;
        if (CollUtil.isNotEmpty(list)) {
            if (list.size() >= 2) {
                isError = true;
            }
            if (list.size() == 1) {
                TuCertificate tuCertificate = list.get(0);
                if (!record.getId().equals(tuCertificate.getId())) {
                    isError = true;
                }
            }
        }
        if (isError) {
            throw new ServiceException("\u6570\u636e\u5339\u914d\u5931\u8d25\uff0c\u8bf7\u91cd\u65b0\u751f\u6210");
        }
    }

    private File genCertFile(RaTuCertificate certificateData) {
        OfflineCertConfig certSetting = new OfflineCertConfig();
        boolean rotate = CertBgEnum.isRotate((Long)certificateData.getBackgroundId());
        String bgImg = CertBgEnum.getBgImg((Long)certificateData.getBackgroundId());
        String bgImgPreBase = "templates/images/" + bgImg;
        URL resource = ResourceUtil.getResource((String)bgImgPreBase);
        String certFileName = CertBgEnum.getCertFile((Long)certificateData.getBackgroundId());
        HashMap<String, Object> dataMap = new HashMap<String, Object>(5);
        dataMap.put("certificateData", certificateData);
        dataMap.put("score", "\u5408\u683c");
        dataMap.put("certTypeName", TrainingPersonTypeEnum.getNameByValue2((String)certificateData.getCertType()));
        dataMap.put("bgImgUrl", resource.getPath());
        dataMap.put("color", CertBgEnum.getColorValue((Long)certificateData.getBackgroundId()));
        dataMap.put("certSetting", certSetting);
        String uploadDir = UploadFileParameter.FILE_PATH + FileResourceEnum.radiation_training.getCode() + UploadFileParameter.FILE_PATH_SEP + UploadFilePathEnum.CERT.getPath() + UploadFileParameter.FILE_PATH_SEP + FileUploadSimple.getDataPath() + UploadFileParameter.FILE_PATH_SEP + IdUtil.getSnowflakeNextId();
        String realPath = this.ossClientBean.getLocal() + uploadDir;
        String filePath = realPath + UploadFileParameter.FILE_PATH_SEP + certificateData.getUname() + "-" + certificateData.getCertificateNo() + ".pdf";
        String qrUrl = this.sysProperties.getCertQrUrl() + certificateData.getId();
        dataMap.put("qrUrl", QrCodeUtil.generateAsBase64((String)qrUrl, (QrConfig)new QrConfig(150, 150), (String)"jpg"));
        dataMap.put("certFont", ResourceUtil.getResource((String)certFont).getPath());
        try {
            Files.createDirectories(Paths.get(realPath, new String[0]), new FileAttribute[0]);
            ConverterProperties properties = new ConverterProperties();
            File file = new File(filePath);
            FileOutputStream os = new FileOutputStream(file);
            PdfWriter pdfWriter = new PdfWriter((OutputStream)os);
            PdfDocument pdfDocument = new PdfDocument(pdfWriter);
            PageSize pageSize = PageSize.A4;
            if (rotate) {
                pageSize = pageSize.rotate();
            }
            pageSize.applyMargins(0.0f, 0.0f, 0.0f, 0.0f, true);
            pdfDocument.setDefaultPageSize(pageSize);
            pdfDocument.getDocumentInfo().setAuthor("\u667a\u6167\u804c\u5b89\u73af\u4fdd\u79d1\u6280").setCreator("\u6d59\u6c5f\u804c\u4e1a\u5065\u5eb7\u5728\u7ebf\u7cfb\u7edf").setKeywords("\u804c\u4e1a\u5065\u5eb7\u5728\u7ebf\u57f9\u8bad\u8bc1\u4e66").setTitle(String.format("%s\u7684\u8bc1\u4e66", "\u7ebf\u4e0b\u57f9\u8bad\u8bc1\u4e66")).setSubject(String.format("%s\u7684\u8bc1\u4e66", "\u7ebf\u4e0b\u57f9\u8bad\u8bc1\u4e66"));
            HtmlConverter.convertToPdf((String)FreemarkUtil.loadFreemarkFile(dataMap, (String)certFileName), (PdfDocument)pdfDocument, (ConverterProperties)properties);
            return file;
        }
        catch (Exception e) {
            log.error("Exception\uff1a", (Throwable)e);
            return null;
        }
    }

    public SysFileModel uploadBackstage(File file, String ossFileName) {
        if (file == null) {
            throw new ServiceException("\u751f\u6210\u8bc1\u4e66\u5931\u8d25\uff0c\u60a8\u53ef\u5c1d\u8bd5\u7a0d\u540e\u518d\u6b21\u64cd\u4f5c\uff01");
        }
        String uploadDir = file.getParent().replace(this.ossClientBean.getLocal(), "").replace("\\", "/");
        int fileResource = FileResourceEnum.radiation_training.getValue();
        String originalFilename = file.getName();
        String fileExt = FilenameUtils.getExtension((String)file.getName());
        String ossUrl = null;
        String fullname = StringUtils.isEmpty((CharSequence)FilenameUtils.getExtension((String)originalFilename)) ? originalFilename + "." + fileExt : originalFilename;
        ossUrl = this.ossClientBean.OSSPutObject(ossFileName, file, uploadDir, fullname);
        log.debug("\u4e0a\u4f20\u540e\u7684\u6587\u4ef6\u8def\u5f84\u4e3a\uff1a{}", (Object)ossUrl);
        SysFileModel sysFileModel = new SysFileModel();
        sysFileModel.setResource(Integer.valueOf(fileResource)).setFileName(originalFilename).setFileSize(String.valueOf(file.getFreeSpace())).setFileExt(fileExt).setFileHash(MD5.create().digestHex(file)).setOssUrl(ossUrl);
        file.delete();
        return this.sysFileProvideService.addSysFile(sysFileModel, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String syncCertInfo(RaTuCertificate certificate) {
        if (StrUtil.isBlank((CharSequence)certificate.getPdfUrl())) {
            return "\u8bc1\u4e66\u672a\u751f\u6210";
        }
        if (certificate.getStatus() == null || certificate.getStatus() != 2) {
            return "\u8bc1\u4e66\u672a\u63d0\u4ea4";
        }
        if (certificate.getTrainingResult() == null || certificate.getTrainingResult() != 1) {
            return "\u57f9\u8bad\u7ed3\u679c\u4e0d\u53ca\u683c";
        }
        String s = null;
        String errResult = null;
        try {
            RaTraining training = (RaTraining)this.trainingService.getById(certificate.getTid());
            TrainingOfflineCertSyncParam syncParam = this.genSyncParam(certificate, training);
            s = this.rayTrainingSyncProvider.syncOfflineTrainingCert(syncParam);
            this.updateSyncResult(certificate.getId(), s);
            if (s != null && s.contains("\u540c\u6b65\u6210\u529f")) {
                errResult = s;
            }
        }
        catch (Exception e) {
            try {
                log.error("Exception\uff1a", (Throwable)e);
                s = "\u8fdc\u7a0b\u63a5\u53e3\u8c03\u7528\u5f02\u5e38";
                this.updateSyncResult(certificate.getId(), s);
                if (s != null && s.contains("\u540c\u6b65\u6210\u529f")) {
                    errResult = s;
                }
            }
            catch (Throwable throwable) {
                this.updateSyncResult(certificate.getId(), s);
                if (s != null && s.contains("\u540c\u6b65\u6210\u529f")) {
                    errResult = s;
                }
                throw throwable;
            }
        }
        return errResult;
    }

    private TrainingOfflineCertSyncParam genSyncParam(RaTuCertificate record, RaTraining training) {
        String trainingType = "0";
        SysFile file = this.sysFileProvideService.getRawFileData(record.getPdfFileId());
        TrainingOfflineCertSyncParam syncParam = new TrainingOfflineCertSyncParam();
        syncParam.setIdCard(record.getIdCard()).setName(record.getUname()).setSourceTrainingId(record.getTid()).setSourceCertId(record.getId()).setCid(record.getCid()).setTechName(record.getTrainingUnitName()).setCertType(TrainingPersonTypeEnum.getTcode((String)record.getCertType())).setCertNo(record.getCertificateNo()).setIssuanceDate(record.getIssueTime() == null ? null : LocalDate.from(DateUtil.toLocalDateTime((Date)record.getIssueTime()))).setCertValidDate(record.getInvalidDate() == null ? null : DateUtil.toLocalDateTime((Date)record.getInvalidDate())).setTrainingName(training.getName()).setTrainingBeginDate(training.getStartTime() == null ? null : LocalDate.from(DateUtil.toLocalDateTime((Date)training.getStartTime()))).setTrainingEndDate(training.getEndTime() == null ? null : LocalDate.from(DateUtil.toLocalDateTime((Date)training.getEndTime()))).setTrainingType(trainingType).setResult(Integer.valueOf(1)).setTrainingContent(null).setTrainingHours(null);
        syncParam.setTechName(record.getTrainingUnitName());
        if (file != null) {
            syncParam.setOssUrl(file.getOssUrl()).setSourceFileId(file.getId()).setFileName(file.getFileName()).setFileSize(StrUtil.isNumeric((CharSequence)file.getFileSize()) ? Long.valueOf(file.getFileSize()) : null).setFileExt(file.getFileExt()).setFileHash(file.getFileHash()).setCreatorIp(file.getCreatorIp());
        }
        return syncParam;
    }

    private void updateSyncResult(Long tuCertificateId, String s) {
        RaTuCertificate tuCertificate = new RaTuCertificate();
        if (tuCertificateId == null) {
            throw new ServiceException("\u65e0\u6cd5\u8bc6\u522b\u8bc1\u4e66");
        }
        tuCertificate.setId(tuCertificateId);
        tuCertificate.setSyncDes(StringUtils.isEmpty((CharSequence)s) ? "\u540c\u6b65\u6210\u529f" : s);
        tuCertificate.setSyncState(Integer.valueOf(StringUtils.isEmpty((CharSequence)s) ? 1 : 2));
        this.offlineCertificateService.updateById(tuCertificate);
    }

    private void updateCertificateNo(RaTuCertificate record) {
        if (record.getId() == null || StrUtil.isBlank((CharSequence)record.getCertificateNo())) {
            throw new ServiceException("\u8bc1\u4e66\u7f16\u53f7\u6216\u8005\u7f16\u7801\u4e0d\u53ef\u4e3a\u7a7a");
        }
        RaTuCertificate tuCertificate = new RaTuCertificate();
        tuCertificate.setId(record.getId());
        tuCertificate.setAreaId(record.getAreaId());
        tuCertificate.setYear(record.getYear());
        tuCertificate.setSerialNo(record.getSerialNo());
        tuCertificate.setCertificateNo(record.getCertificateNo());
        this.offlineCertificateService.updateById(tuCertificate);
    }

    @Generated
    public CertOfflineRayService() {
    }
}

